/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.chunk.defaults;

import eu.cloudnetservice.common.io.FileUtil;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.chunk.ChunkedPacketHandler;
import eu.cloudnetservice.driver.network.chunk.TransferStatus;
import eu.cloudnetservice.driver.network.chunk.data.ChunkSessionInformation;
import eu.cloudnetservice.driver.network.chunk.defaults.DefaultChunkedPacketProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class DefaultFileChunkedPacketHandler
extends DefaultChunkedPacketProvider
implements ChunkedPacketHandler {
    protected final Path tempFilePath;
    protected final RandomAccessFile targetFile;
    protected final ChunkedPacketHandler.Callback writeCompleteHandler;
    protected final Lock lock = new ReentrantLock();
    protected int writtenFileParts = -1;
    protected int expectedFileParts = -1;

    public DefaultFileChunkedPacketHandler(@NonNull ChunkSessionInformation sessionInformation, @Nullable ChunkedPacketHandler.Callback completeHandler) {
        this(sessionInformation, completeHandler, FileUtil.createTempFile());
        if (sessionInformation == null) {
            throw new NullPointerException("sessionInformation is marked non-null but is null");
        }
    }

    public DefaultFileChunkedPacketHandler(@NonNull ChunkSessionInformation sessionInformation, @Nullable ChunkedPacketHandler.Callback completeHandler, @NonNull Path tempFilePath) {
        super(sessionInformation);
        if (sessionInformation == null) {
            throw new NullPointerException("sessionInformation is marked non-null but is null");
        }
        if (tempFilePath == null) {
            throw new NullPointerException("tempFilePath is marked non-null but is null");
        }
        this.tempFilePath = tempFilePath;
        this.writeCompleteHandler = completeHandler;
        this.targetFile = this.openTempFile();
    }

    @NonNull
    private RandomAccessFile openTempFile() {
        try {
            if (Files.notExists(this.tempFilePath, new LinkOption[0])) {
                Files.createFile(this.tempFilePath, new FileAttribute[0]);
            }
            File pathAsFile = this.tempFilePath.toFile();
            return new RandomAccessFile(pathAsFile, "rwd");
        }
        catch (IOException exception) {
            throw new IllegalStateException("cannot open chunk transfer temp file for writing", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleChunkPart(int chunkPosition, @NonNull DataBuf dataBuf) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        if (this.transferStatus == TransferStatus.FAILURE) {
            return false;
        }
        boolean isFinalPacket = dataBuf.readBoolean();
        if (isFinalPacket) {
            this.expectedFileParts = chunkPosition;
        }
        this.lock.lock();
        try {
            if (this.transferStatus != TransferStatus.RUNNING) {
                throw new IllegalStateException("chunked transfer received data after completion");
            }
            this.writePacketContent(chunkPosition, dataBuf);
            ++this.writtenFileParts;
            if (this.expectedFileParts != -1 && this.expectedFileParts == this.writtenFileParts) {
                boolean closeStream;
                this.transferStatus = TransferStatus.SUCCESS;
                this.targetFile.close();
                if (this.writeCompleteHandler != null) {
                    closeStream = true;
                    InputStream stream = InputStream.nullInputStream();
                    try {
                        stream = Files.newInputStream(this.tempFilePath, StandardOpenOption.DELETE_ON_CLOSE);
                        closeStream = this.writeCompleteHandler.handleSessionComplete(this.chunkSessionInformation, stream);
                    }
                    finally {
                        if (closeStream) {
                            stream.close();
                        }
                    }
                }
                closeStream = true;
                return closeStream;
            }
            boolean closeStream = false;
            return closeStream;
        }
        catch (IOException exception) {
            this.transferStatus = TransferStatus.FAILURE;
            throw new IllegalStateException("Unexpected exception handling chunk part", exception);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void writePacketContent(int chunkPosition, @NonNull DataBuf dataBuf) throws IOException {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        long filePosition = Math.multiplyFull(chunkPosition, this.chunkSessionInformation.chunkSize());
        this.targetFile.seek(filePosition);
        this.targetFile.write(dataBuf.readByteArray());
    }
}

