/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.inject;

import dev.derklaro.aerogel.ContextualProvider;
import dev.derklaro.aerogel.Element;
import dev.derklaro.aerogel.InjectionContext;
import dev.derklaro.aerogel.Injector;
import dev.derklaro.aerogel.SpecifiedInjector;
import dev.derklaro.aerogel.auto.runtime.AutoAnnotationRegistry;
import dev.derklaro.aerogel.binding.BindingConstructor;
import dev.derklaro.aerogel.binding.BindingHolder;
import dev.derklaro.aerogel.internal.context.util.ContextInstanceResolveHelper;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import eu.cloudnetservice.driver.inject.InjectionLayerProvider;
import eu.cloudnetservice.driver.inject.UncloseableInjectionLayer;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.UnknownNullability;

record DefaultInjectionLayer<I extends Injector>(@NonNull I injector, @NonNull AutoAnnotationRegistry autoRegistry, @NonNull String name) implements InjectionLayer<I>
{
    @Generated
    public DefaultInjectionLayer(@NonNull I injector, @NonNull AutoAnnotationRegistry autoRegistry, @NonNull String name) {
        if (injector == null) {
            throw new NullPointerException("injector is marked non-null but is null");
        }
        if (autoRegistry == null) {
            throw new NullPointerException("autoRegistry is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
    }

    @Override
    public <T> @UnknownNullability T instance(@NonNull Class<T> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return (T)this.injector.instance(type);
    }

    @Override
    public <T> @UnknownNullability T instance(@NonNull Element element) {
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        return (T)this.injector.instance(element);
    }

    @Override
    public <T> @UnknownNullability T instance(@NonNull Class<T> type, @NonNull Consumer<InjectionContext.Builder> builder) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        Element element = Element.forType(type);
        BindingHolder binding = this.injector.binding(element);
        InjectionContext.Builder contextBuilder = InjectionContext.builder(type, (ContextualProvider)binding.provider(element));
        builder.accept(contextBuilder);
        return (T)ContextInstanceResolveHelper.resolveInstanceAndRemoveContext((InjectionContext)contextBuilder.build());
    }

    @Override
    public void install(@NonNull BindingConstructor constructor) {
        if (constructor == null) {
            throw new NullPointerException("constructor is marked non-null but is null");
        }
        this.injector.install(constructor);
    }

    @Override
    public void installAutoConfigureBindings(@NonNull ClassLoader loader, @NonNull String component) {
        if (loader == null) {
            throw new NullPointerException("loader is marked non-null but is null");
        }
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        String fileName = String.format("autoconfigure/%s.aero", component);
        this.autoRegistry.installBindings(loader, fileName, this.injector);
    }

    @Override
    @NonNull
    public InjectionLayer<I> asUncloseable() {
        return new UncloseableInjectionLayer(this);
    }

    @Override
    @NonNull
    public InjectionLayer<I> register(Object ... hints) {
        if (hints == null) {
            throw new NullPointerException("hints is marked non-null but is null");
        }
        InjectionLayerProvider.REGISTRY.registerLayer(this, hints);
        return this;
    }

    @Override
    public void close() {
        I i = this.injector;
        if (i instanceof SpecifiedInjector) {
            SpecifiedInjector specifiedInjector = (SpecifiedInjector)i;
            specifiedInjector.removeConstructedBindings();
        }
        InjectionLayerProvider.REGISTRY.unregisterLayer(this);
    }
}

