/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.event;

import dev.derklaro.aerogel.Element;
import dev.derklaro.reflexion.MethodAccessor;
import dev.derklaro.reflexion.Reflexion;
import dev.derklaro.reflexion.Result;
import eu.cloudnetservice.driver.event.Event;
import eu.cloudnetservice.driver.event.EventListener;
import eu.cloudnetservice.driver.event.EventListenerException;
import eu.cloudnetservice.driver.event.InvocationOrder;
import eu.cloudnetservice.driver.event.RegisteredEventListener;
import eu.cloudnetservice.driver.inject.InjectUtil;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import java.lang.reflect.Method;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultRegisteredEventListener
implements RegisteredEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRegisteredEventListener.class);
    private final Object instance;
    private final Class<?> eventClass;
    private final EventListener eventListener;
    private final String methodName;
    private final Element[] methodArguments;
    private final MethodAccessor<?> methodAccessor;
    private final InjectionLayer<?> injectionLayer;

    DefaultRegisteredEventListener(@NonNull Object instance, @NonNull Method targetMethod, @NonNull EventListener eventListener, @NonNull InjectionLayer<?> injectionLayer) {
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        if (targetMethod == null) {
            throw new NullPointerException("targetMethod is marked non-null but is null");
        }
        if (eventListener == null) {
            throw new NullPointerException("eventListener is marked non-null but is null");
        }
        if (injectionLayer == null) {
            throw new NullPointerException("injectionLayer is marked non-null but is null");
        }
        this.instance = instance;
        this.eventListener = eventListener;
        this.injectionLayer = injectionLayer;
        this.methodName = targetMethod.getName();
        this.eventClass = targetMethod.getParameterTypes()[0];
        Reflexion reflexion = Reflexion.onBound((Object)instance);
        this.methodAccessor = reflexion.unreflect(targetMethod);
        this.methodArguments = InjectUtil.buildElementsForParameters(targetMethod.getParameters(), 1);
    }

    @Override
    public void fireEvent(@NonNull Event event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        LOGGER.debug("Calling event {} on listener {}", (Object)event.getClass().getName(), (Object)this.instance().getClass().getName());
        Object[] instances = InjectUtil.findAllInstances(this.injectionLayer, this.methodArguments, 1);
        instances[0] = event;
        Result result = this.methodAccessor.invokeWithArgs(instances);
        if (result.wasExceptional()) {
            throw new EventListenerException(String.format("Error while invoking event listener %s in class %s", this.methodName, this.instance.getClass().getName()), result.getException());
        }
    }

    @Override
    @NonNull
    public String channel() {
        return this.eventListener.channel();
    }

    @Override
    @NonNull
    public InvocationOrder order() {
        return this.eventListener.order();
    }

    @Override
    @NonNull
    public Object instance() {
        return this.instance;
    }

    @Override
    @NonNull
    public Class<?> eventClass() {
        return this.eventClass;
    }

    @Override
    @NonNull
    public EventListener eventListener() {
        return this.eventListener;
    }
}

