/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.document.property;

import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.property.StandardDocProperty;
import java.lang.reflect.Type;
import java.util.function.Function;
import lombok.NonNull;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.Nullable;

public interface DocProperty<E> {
    @NonNull
    public static <E> DocProperty<E> property(@NonNull String key, @NonNull Class<E> type) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return new StandardDocProperty(key, type);
    }

    @NonNull
    public static <E> DocProperty<E> genericProperty(@NonNull String key, @NonNull Type type) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return new StandardDocProperty(key, type);
    }

    @NonNull
    public String key();

    public boolean readOnly();

    @CheckReturnValue
    @NonNull
    public DocProperty<E> asReadOnly();

    @CheckReturnValue
    @NonNull
    public DocProperty<E> withDefault(@Nullable E var1);

    @CheckReturnValue
    @NonNull
    public <V> DocProperty<V> withReadRewrite(@NonNull Function<E, V> var1);

    @CheckReturnValue
    @NonNull
    public <V> DocProperty<V> withReadWriteRewrite(@NonNull Function<E, V> var1, @Nullable Function<V, E> var2);

    @Nullable
    public E readFrom(@NonNull Document var1);

    @NonNull
    public DocProperty<E> writeTo(@NonNull Document.Mutable var1, @Nullable E var2);
}

