/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.document.property;

import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.property.DocProperty;
import eu.cloudnetservice.driver.document.property.DocPropertyHolder;
import eu.cloudnetservice.driver.document.send.DocumentSend;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public interface DefaultedDocPropertyHolder
extends DocPropertyHolder {
    @Override
    default public <E> @UnknownNullability E readProperty(@NonNull DocProperty<E> property) {
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        return property.readFrom(this.propertyHolder());
    }

    @Override
    default public <E> @UnknownNullability E readPropertyOrDefault(@NonNull DocProperty<E> property, @Nullable E def) {
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        E knownProperty = this.readProperty(property);
        return knownProperty == null ? def : knownProperty;
    }

    @Override
    default public <E> @UnknownNullability E readPropertyOrGet(@NonNull DocProperty<E> property, @NonNull Supplier<? extends E> supplier) {
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        E knownProperty = this.readProperty(property);
        return knownProperty == null ? supplier.get() : knownProperty;
    }

    @Override
    @NonNull
    default public <E> E readPropertyOrThrow(@NonNull DocProperty<E> property) {
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        return this.readPropertyOrThrow(property, NoSuchElementException::new);
    }

    @Override
    @NonNull
    default public <E, T extends Throwable> E readPropertyOrThrow(@NonNull DocProperty<E> property, @NonNull Supplier<? extends T> exceptionSupplier) throws T {
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        if (exceptionSupplier == null) {
            throw new NullPointerException("exceptionSupplier is marked non-null but is null");
        }
        E value = this.readProperty(property);
        if (value == null) {
            throw (Throwable)exceptionSupplier.get();
        }
        return value;
    }

    @Override
    default public <E> boolean propertyPresent(@NonNull DocProperty<E> property) {
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        return this.propertyHolder().contains(property.key());
    }

    @Override
    default public <E> boolean propertyAbsent(@NonNull DocProperty<E> property) {
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        return !this.propertyHolder().contains(property.key());
    }

    public static interface Mutable<S extends DocPropertyHolder.Mutable<S>>
    extends DefaultedDocPropertyHolder,
    DocPropertyHolder.Mutable<S> {
        @Override
        @NonNull
        default public <E> S writeProperty(@NonNull DocProperty<E> property, @Nullable E value) {
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            property.writeTo((Document.Mutable)this.propertyHolder(), value);
            return (S)this;
        }

        @Override
        @NonNull
        default public <E> S writePropertyIfAbsent(@NonNull DocProperty<E> property, @Nullable E value) {
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            if (this.propertyAbsent(property)) {
                property.writeTo((Document.Mutable)this.propertyHolder(), value);
            }
            return (S)this;
        }

        @Override
        @NonNull
        default public <E> S writePropertyIfAbsent(@NonNull DocProperty<E> property, @NonNull Supplier<? extends E> valueSupplier) {
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            if (valueSupplier == null) {
                throw new NullPointerException("valueSupplier is marked non-null but is null");
            }
            if (this.propertyAbsent(property)) {
                property.writeTo((Document.Mutable)this.propertyHolder(), valueSupplier.get());
            }
            return (S)this;
        }

        @Override
        @NonNull
        default public <E> S writePropertyIfPresent(@NonNull DocProperty<E> property, @Nullable E val) {
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            if (this.propertyPresent(property)) {
                property.writeTo((Document.Mutable)this.propertyHolder(), val);
            }
            return (S)this;
        }

        @Override
        @NonNull
        default public <E> S writePropertyIfPresent(@NonNull DocProperty<E> property, @NonNull Supplier<? extends E> valueSupplier) {
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            if (valueSupplier == null) {
                throw new NullPointerException("valueSupplier is marked non-null but is null");
            }
            if (this.propertyPresent(property)) {
                property.writeTo((Document.Mutable)this.propertyHolder(), valueSupplier.get());
            }
            return (S)this;
        }

        @Override
        @Nullable
        default public <E> E removeProperty(@NonNull DocProperty<E> property) {
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            if (property.readOnly()) {
                throw new UnsupportedOperationException("Cannot remove read-only property");
            }
            E value = this.readProperty(property);
            this.propertyHolder().remove(property.key());
            return value;
        }

        public static interface WithDirectModifier<S extends DocPropertyHolder.Mutable<S>>
        extends Mutable<S> {
            @NonNull
            default public S modifyProperties(@NonNull Consumer<Document.Mutable> propertyModifier) {
                if (propertyModifier == null) {
                    throw new NullPointerException("propertyModifier is marked non-null but is null");
                }
                propertyModifier.accept((Document.Mutable)this.propertyHolder());
                return (S)this;
            }

            @NonNull
            default public S modifyAndSetProperties(@NonNull Function<Document.Mutable, ? extends Document> modifier) {
                if (modifier == null) {
                    throw new NullPointerException("modifier is marked non-null but is null");
                }
                Document modificationResult = modifier.apply((Document.Mutable)this.propertyHolder());
                if (modificationResult != null) {
                    this.propertyHolder().clear();
                    DocumentSend send = modificationResult.send();
                    this.propertyHolder().receive(send);
                }
                return (S)this;
            }
        }
    }
}

