/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.document.gson.send;

import com.google.gson.JsonPrimitive;
import eu.cloudnetservice.driver.document.send.element.PrimitiveElement;
import lombok.NonNull;

final class GsonPrimitiveConverter {
    private GsonPrimitiveConverter() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static JsonPrimitive wrapAsPrimitive(@NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (value instanceof String) {
            String string = (String)value;
            return new JsonPrimitive(string);
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return new JsonPrimitive(number);
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return new JsonPrimitive(bool);
        }
        if (value instanceof Character) {
            Character c = (Character)value;
            return new JsonPrimitive(c);
        }
        throw new IllegalArgumentException("Invalid primitive type " + String.valueOf(value.getClass()) + " must be one of: String, Number, Boolean, Character");
    }

    @NonNull
    public static PrimitiveElement unwrapJsonPrimitive(@NonNull String key, @NonNull JsonPrimitive primitive) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (primitive == null) {
            throw new NullPointerException("primitive is marked non-null but is null");
        }
        if (primitive.isString()) {
            return new PrimitiveElement(key, primitive.getAsString());
        }
        if (primitive.isNumber()) {
            return new PrimitiveElement(key, primitive.getAsNumber());
        }
        if (primitive.isBoolean()) {
            return new PrimitiveElement(key, primitive.getAsBoolean());
        }
        throw new IllegalArgumentException("Unable to read inner value of " + String.valueOf(primitive));
    }
}

