/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.document.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

final class TimeTypeAdapter<T extends TemporalAccessor>
extends TypeAdapter<T> {
    private final TemporalQuery<T> query;
    private final DateTimeFormatter formatter;
    private final TypeAdapter<String> stringTypeAdapter;

    private TimeTypeAdapter(@NonNull TemporalQuery<T> query, @NonNull DateTimeFormatter formatter, @NonNull TypeAdapter<String> stringTypeAdapter) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        if (stringTypeAdapter == null) {
            throw new NullPointerException("stringTypeAdapter is marked non-null but is null");
        }
        this.query = query;
        this.formatter = formatter;
        this.stringTypeAdapter = stringTypeAdapter;
    }

    @NonNull
    public static <T extends TemporalAccessor> TimeTypeAdapter<T> of(@NonNull TemporalQuery<T> query, @NonNull DateTimeFormatter formatter, @NonNull Gson gsonInstance) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        if (gsonInstance == null) {
            throw new NullPointerException("gsonInstance is marked non-null but is null");
        }
        return new TimeTypeAdapter<T>(query, formatter, (TypeAdapter<String>)gsonInstance.getAdapter(String.class));
    }

    public void write(@NonNull JsonWriter out, @Nullable T value) throws IOException {
        if (out == null) {
            throw new NullPointerException("out is marked non-null but is null");
        }
        this.stringTypeAdapter.write(out, value == null ? null : this.formatter.format((TemporalAccessor)value));
    }

    @Nullable
    public T read(@NonNull JsonReader in) throws IOException {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        String time = (String)this.stringTypeAdapter.read(in);
        return (T)(time == null ? null : (TemporalAccessor)this.formatter.parse((CharSequence)time, this.query));
    }
}

