/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.document.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

final class PatternTypeAdapter
extends TypeAdapter<Pattern> {
    private final TypeAdapter<String> stringTypeAdapter;

    public PatternTypeAdapter(@NonNull Gson gsonInstance) {
        if (gsonInstance == null) {
            throw new NullPointerException("gsonInstance is marked non-null but is null");
        }
        this.stringTypeAdapter = gsonInstance.getAdapter(String.class);
    }

    public void write(@NonNull JsonWriter out, @Nullable Pattern value) throws IOException {
        if (out == null) {
            throw new NullPointerException("out is marked non-null but is null");
        }
        this.stringTypeAdapter.write(out, (Object)(value == null ? null : value.pattern()));
    }

    @Nullable
    public Pattern read(@NonNull JsonReader in) throws IOException {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        String pattern = (String)this.stringTypeAdapter.read(in);
        return pattern == null ? null : Pattern.compile(pattern);
    }
}

