/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.document.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

final class PathTypeAdapter
extends TypeAdapter<Path> {
    private final TypeAdapter<String> stringTypeAdapter;

    public PathTypeAdapter(@NonNull Gson gsonInstance) {
        if (gsonInstance == null) {
            throw new NullPointerException("gsonInstance is marked non-null but is null");
        }
        this.stringTypeAdapter = gsonInstance.getAdapter(String.class);
    }

    public void write(@NonNull JsonWriter out, @Nullable Path value) throws IOException {
        if (out == null) {
            throw new NullPointerException("out is marked non-null but is null");
        }
        this.stringTypeAdapter.write(out, value == null ? null : value.toString().replace(File.separatorChar, '/'));
    }

    @Nullable
    public Path read(@NonNull JsonReader in) throws IOException {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        String path = (String)this.stringTypeAdapter.read(in);
        return path == null ? null : Path.of(path, new String[0]);
    }
}

