/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.document.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.DocumentFactory;
import eu.cloudnetservice.driver.document.DocumentParseException;
import eu.cloudnetservice.driver.document.gson.GsonProvider;
import eu.cloudnetservice.driver.document.gson.MutableGsonDocument;
import eu.cloudnetservice.driver.document.send.DocumentSend;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public final class GsonDocumentFactory
implements DocumentFactory {
    public static final DocumentFactory INSTANCE = new GsonDocumentFactory();

    private GsonDocumentFactory() {
    }

    @Override
    @NonNull
    public String formatName() {
        return "json";
    }

    @Override
    @NonNull
    public Document.Mutable parse(byte[] data) {
        Document.Mutable mutable;
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        try {
            mutable = this.parse(stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                throw new DocumentParseException(exception);
            }
        }
        stream.close();
        return mutable;
    }

    @Override
    @NonNull
    public Document.Mutable parse(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0])) {
            Document.Mutable mutable;
            block10: {
                InputStream stream = Files.newInputStream(path, new OpenOption[0]);
                try {
                    mutable = this.parse(stream);
                    if (stream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException exception) {
                        throw new DocumentParseException("Unable to parse document from path " + String.valueOf(path), exception);
                    }
                }
                stream.close();
            }
            return mutable;
        }
        return this.newDocument();
    }

    @Override
    @NonNull
    public Document.Mutable parse(@NonNull String data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        try (StringReader reader = new StringReader(data);){
            Document.Mutable mutable = this.parse(reader);
            return mutable;
        }
    }

    @Override
    @NonNull
    public Document.Mutable parse(@NonNull Reader reader) {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        try {
            JsonElement element = JsonParser.parseReader((Reader)reader);
            return element.isJsonObject() ? new MutableGsonDocument(element.getAsJsonObject()) : this.newDocument();
        }
        catch (JsonParseException exception) {
            throw new DocumentParseException(exception);
        }
    }

    @Override
    @NonNull
    public Document.Mutable parse(@NonNull InputStream stream) {
        Document.Mutable mutable;
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        try {
            mutable = this.parse(reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                throw new DocumentParseException(exception);
            }
        }
        reader.close();
        return mutable;
    }

    @Override
    @NonNull
    public Document.Mutable parse(@NonNull DataBuf dataBuf) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        return this.parse(dataBuf.readString());
    }

    @Override
    @NonNull
    public Document.Mutable newDocument() {
        return new MutableGsonDocument();
    }

    @Override
    @NonNull
    public Document.Mutable newDocument(@Nullable Object wrapped) {
        JsonElement element = GsonProvider.NORMAL_GSON_INSTANCE.toJsonTree(wrapped);
        return element.isJsonObject() ? new MutableGsonDocument(element.getAsJsonObject()) : this.newDocument();
    }

    @Override
    @NonNull
    public Document.Mutable newDocument(@NonNull String key, @Nullable Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        JsonElement element = GsonProvider.NORMAL_GSON_INSTANCE.toJsonTree(value);
        JsonObject object = new JsonObject();
        object.add(key, element);
        return new MutableGsonDocument(object);
    }

    @Override
    @NonNull
    public Document.Mutable receive(@NonNull DocumentSend send) {
        if (send == null) {
            throw new NullPointerException("send is marked non-null but is null");
        }
        return this.newDocument().receive(send);
    }
}

