/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.document;

import eu.cloudnetservice.driver.document.DocumentFactory;
import eu.cloudnetservice.driver.document.SerialisationStyle;
import eu.cloudnetservice.driver.document.StandardSerialisationStyle;
import eu.cloudnetservice.driver.document.empty.EmptyDocument;
import eu.cloudnetservice.driver.document.property.DocPropertyHolder;
import eu.cloudnetservice.driver.document.send.DocumentSend;
import eu.cloudnetservice.driver.document.send.element.Element;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import io.leangen.geantyref.TypeToken;
import java.io.Externalizable;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import lombok.NonNull;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.Unmodifiable;

public interface Document
extends DocPropertyHolder,
Externalizable {
    @NonNull
    public static Mutable emptyDocument() {
        return EmptyDocument.INSTANCE;
    }

    @NonNull
    public static Mutable newJsonDocument() {
        return Document.newDocument(DocumentFactory.json());
    }

    @NonNull
    public static Mutable newDocument(@NonNull DocumentFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        return factory.newDocument();
    }

    @NonNull
    public String factoryName();

    public boolean empty();

    public int elementCount();

    public boolean contains(@NonNull String var1);

    public boolean containsNonNull(@NonNull String var1);

    @NonNull
    public DocumentSend send();

    @CheckReturnValue
    @NonNull
    public Document immutableCopy();

    @CheckReturnValue
    @NonNull
    public Mutable mutableCopy();

    public @Unmodifiable @NonNull Set<String> keys();

    public @Unmodifiable @NonNull Collection<? extends Element> elements();

    public <T> @UnknownNullability T toInstanceOf(@NonNull Type var1);

    public <T> @UnknownNullability T toInstanceOf(@NonNull Class<T> var1);

    public <T> @UnknownNullability T toInstanceOf(@NonNull TypeToken<T> var1);

    default public <T> @UnknownNullability T readObject(@NonNull String key, @NonNull Type type) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.readObject(key, type, null);
    }

    default public <T> @UnknownNullability T readObject(@NonNull String key, @NonNull Class<T> type) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.readObject(key, type, null);
    }

    default public <T> @UnknownNullability T readObject(@NonNull String key, @NonNull TypeToken<T> type) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.readObject(key, type, null);
    }

    public <T> @UnknownNullability T readObject(@NonNull String var1, @NonNull Type var2, @Nullable T var3);

    public <T> @UnknownNullability T readObject(@NonNull String var1, @NonNull Class<T> var2, @Nullable T var3);

    public <T> @UnknownNullability T readObject(@NonNull String var1, @NonNull TypeToken<T> var2, @Nullable T var3);

    @NonNull
    default public Document readDocument(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.readDocument(key, Document.emptyDocument());
    }

    public @UnknownNullability Document readDocument(@NonNull String var1, @Nullable Document var2);

    default public @NonNull Mutable readMutableDocument(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.readMutableDocument(key, Document.emptyDocument());
    }

    public @UnknownNullability Mutable readMutableDocument(@NonNull String var1, @Nullable Mutable var2);

    default public byte getByte(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getByte(key, (byte)0);
    }

    default public short getShort(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getShort(key, (short)0);
    }

    default public int getInt(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getInt(key, 0);
    }

    default public long getLong(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getLong(key, 0L);
    }

    default public float getFloat(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getFloat(key, 0.0f);
    }

    default public double getDouble(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getDouble(key, 0.0);
    }

    default public boolean getBoolean(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getBoolean(key, false);
    }

    default public @UnknownNullability String getString(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getString(key, null);
    }

    public byte getByte(@NonNull String var1, byte var2);

    public short getShort(@NonNull String var1, short var2);

    public int getInt(@NonNull String var1, int var2);

    public long getLong(@NonNull String var1, long var2);

    public float getFloat(@NonNull String var1, float var2);

    public double getDouble(@NonNull String var1, double var2);

    public boolean getBoolean(@NonNull String var1, boolean var2);

    public @UnknownNullability String getString(@NonNull String var1, @Nullable String var2);

    default public void writeTo(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.writeTo(path, (SerialisationStyle)StandardSerialisationStyle.PRETTY);
    }

    default public void writeTo(@NonNull OutputStream stream) {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        this.writeTo(stream, (SerialisationStyle)StandardSerialisationStyle.PRETTY);
    }

    default public void writeTo(@NonNull Appendable appendable) {
        if (appendable == null) {
            throw new NullPointerException("appendable is marked non-null but is null");
        }
        this.writeTo(appendable, (SerialisationStyle)StandardSerialisationStyle.PRETTY);
    }

    default public void writeTo(@NonNull DataBuf.Mutable dataBuf) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        this.writeTo(dataBuf, (SerialisationStyle)StandardSerialisationStyle.COMPACT);
    }

    @NonNull
    default public String serializeToString() {
        return this.serializeToString(StandardSerialisationStyle.PRETTY);
    }

    public void writeTo(@NonNull Path var1, @NonNull SerialisationStyle var2);

    public void writeTo(@NonNull OutputStream var1, @NonNull SerialisationStyle var2);

    public void writeTo(@NonNull Appendable var1, @NonNull SerialisationStyle var2);

    public void writeTo(@NonNull DataBuf.Mutable var1, @NonNull SerialisationStyle var2);

    @NonNull
    public String serializeToString(@NonNull SerialisationStyle var1);

    @NonNull
    public String toString();

    public boolean equals(@Nullable Object var1);

    public static interface Mutable
    extends Document,
    DocPropertyHolder.Mutable<Mutable> {
        @Contract(value="-> this")
        @NonNull
        public Mutable clear();

        @Contract(value="_ -> this")
        @NonNull
        public Mutable remove(@NonNull String var1);

        @Contract(value="_ -> this")
        @NonNull
        public Mutable receive(@NonNull DocumentSend var1);

        @Contract(value="_ -> this")
        @NonNull
        public Mutable appendNull(@NonNull String var1);

        @Contract(value="_ -> this")
        @NonNull
        public Mutable appendTree(@Nullable Object var1);

        @Contract(value="_ -> this")
        @NonNull
        public Mutable append(@NonNull Document var1);

        @Contract(value="_, _ -> this")
        @NonNull
        public Mutable append(@NonNull String var1, @Nullable Object var2);

        @Contract(value="_, _ -> this")
        @NonNull
        public Mutable append(@NonNull String var1, @Nullable Number var2);

        @Contract(value="_, _ -> this")
        @NonNull
        public Mutable append(@NonNull String var1, @Nullable Boolean var2);

        @Contract(value="_, _ -> this")
        @NonNull
        public Mutable append(@NonNull String var1, @Nullable String var2);

        @Contract(value="_, _ -> this")
        @NonNull
        public Mutable append(@NonNull String var1, @Nullable Document var2);
    }
}

