/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.database;

import eu.cloudnetservice.common.concurrent.TaskUtil;
import eu.cloudnetservice.driver.database.Database;
import io.vavr.CheckedFunction0;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

public interface DatabaseProvider {
    @NonNull
    public Database database(@NonNull String var1);

    public boolean containsDatabase(@NonNull String var1);

    public boolean deleteDatabase(@NonNull String var1);

    @NonNull
    public Collection<String> databaseNames();

    @NonNull
    default public CompletableFuture<Boolean> containsDatabaseAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return TaskUtil.supplyAsync((CheckedFunction0 & Serializable)() -> this.containsDatabase(name));
    }

    @NonNull
    default public CompletableFuture<Boolean> deleteDatabaseAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return TaskUtil.supplyAsync((CheckedFunction0 & Serializable)() -> this.deleteDatabase(name));
    }

    @NonNull
    default public CompletableFuture<Collection<String>> databaseNamesAsync() {
        return TaskUtil.supplyAsync(this::databaseNames);
    }
}

