/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.database;

import eu.cloudnetservice.common.Named;
import eu.cloudnetservice.common.concurrent.TaskUtil;
import eu.cloudnetservice.driver.document.Document;
import io.vavr.CheckedFunction0;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public interface Database
extends Named,
AutoCloseable {
    public boolean insert(@NonNull String var1, @NonNull Document var2);

    public boolean contains(@NonNull String var1);

    public boolean delete(@NonNull String var1);

    @Nullable
    public Document get(@NonNull String var1);

    @NonNull
    public Collection<Document> find(@NonNull String var1, @Nullable String var2);

    @NonNull
    public Collection<Document> find(@NonNull Map<String, String> var1);

    @NonNull
    public Collection<String> keys();

    @NonNull
    public Collection<Document> documents();

    @NonNull
    public Map<String, Document> entries();

    public void clear();

    public long documentCount();

    public boolean synced();

    @NonNull
    default public CompletableFuture<Boolean> insertAsync(@NonNull String key, @NonNull Document document) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        return TaskUtil.supplyAsync((CheckedFunction0 & Serializable)() -> this.insert(key, document));
    }

    @NonNull
    default public CompletableFuture<Boolean> containsAsync(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return TaskUtil.supplyAsync((CheckedFunction0 & Serializable)() -> this.contains(key));
    }

    @NonNull
    default public CompletableFuture<Boolean> deleteAsync(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return TaskUtil.supplyAsync((CheckedFunction0 & Serializable)() -> this.delete(key));
    }

    @NonNull
    default public CompletableFuture<Document> getAsync(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return TaskUtil.supplyAsync((CheckedFunction0 & Serializable)() -> this.get(key));
    }

    @NonNull
    default public CompletableFuture<Collection<Document>> findAsync(@NonNull String fieldName, @Nullable String fieldValue) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        return TaskUtil.supplyAsync((CheckedFunction0 & Serializable)() -> this.find(fieldName, fieldValue));
    }

    @NonNull
    default public CompletableFuture<Collection<Document>> findAsync(@NonNull Map<String, String> filters) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        return TaskUtil.supplyAsync((CheckedFunction0 & Serializable)() -> this.find(filters));
    }

    @NonNull
    default public CompletableFuture<Collection<String>> keysAsync() {
        return TaskUtil.supplyAsync(this::keys);
    }

    @NonNull
    default public CompletableFuture<Collection<Document>> documentsAsync() {
        return TaskUtil.supplyAsync(this::documents);
    }

    @NonNull
    default public CompletableFuture<Map<String, Document>> entriesAsync() {
        return TaskUtil.supplyAsync(this::entries);
    }

    @NonNull
    default public CompletableFuture<Void> clearAsync() {
        return TaskUtil.runAsync(this::clear);
    }

    @NonNull
    default public CompletableFuture<Long> documentCountAsync() {
        return TaskUtil.supplyAsync(this::documentCount);
    }
}

