/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.channel;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.driver.service.ServiceEnvironmentType;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public class ChannelMessageTarget {
    private static final ChannelMessageTarget ALL = new ChannelMessageTarget(Type.ALL, null);
    private static final ChannelMessageTarget ALL_NODES = new ChannelMessageTarget(Type.NODE, null);
    private static final ChannelMessageTarget ALL_SERVICES = new ChannelMessageTarget(Type.SERVICE, null);
    private final Type type;
    private final String name;
    private final ServiceEnvironmentType environment;

    protected ChannelMessageTarget(@NonNull Type type, @Nullable String name) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
        this.name = name;
        this.environment = null;
    }

    protected ChannelMessageTarget(@NonNull ServiceEnvironmentType environment) {
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        this.type = Type.ENVIRONMENT;
        this.name = null;
        this.environment = environment;
    }

    protected ChannelMessageTarget(@NonNull Type type, @Nullable String name, @Nullable ServiceEnvironmentType environment) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
        this.name = name;
        this.environment = environment;
    }

    @NonNull
    public static ChannelMessageTarget environment(@NonNull ServiceEnvironmentType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return new ChannelMessageTarget(type);
    }

    @NonNull
    public static ChannelMessageTarget of(@NonNull Type type, @Nullable String name) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        Preconditions.checkArgument((type != Type.ENVIRONMENT ? 1 : 0) != 0, (Object)"Unable to target environment using name");
        if (name == null) {
            switch (type.ordinal()) {
                case 0: {
                    return ALL;
                }
                case 1: {
                    return ALL_NODES;
                }
                case 2: {
                    return ALL_SERVICES;
                }
            }
        }
        return new ChannelMessageTarget(type, name);
    }

    @NonNull
    public Type type() {
        return this.type;
    }

    public @UnknownNullability String name() {
        return this.name;
    }

    public @UnknownNullability ServiceEnvironmentType environment() {
        return this.environment;
    }

    @Generated
    public String toString() {
        return "ChannelMessageTarget(type=" + String.valueOf((Object)this.type) + ", name=" + this.name + ", environment=" + String.valueOf(this.environment) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChannelMessageTarget)) {
            return false;
        }
        ChannelMessageTarget other = (ChannelMessageTarget)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Type this$type = this.type;
        Type other$type = other.type;
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ServiceEnvironmentType this$environment = this.environment;
        ServiceEnvironmentType other$environment = other.environment;
        return !(this$environment == null ? other$environment != null : !((Object)this$environment).equals(other$environment));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChannelMessageTarget;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $type = this.type;
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ServiceEnvironmentType $environment = this.environment;
        result = result * 59 + ($environment == null ? 43 : ((Object)$environment).hashCode());
        return result;
    }

    public static enum Type {
        ALL,
        NODE,
        SERVICE,
        TASK,
        GROUP,
        ENVIRONMENT;

    }
}

