/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.common.util;

import eu.cloudnetservice.common.Named;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

public final class WildcardUtil {
    private static final char[] GROUP_CHARS = new char[]{'(', ')', '[', ']', '{', '}'};

    private WildcardUtil() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static <T extends Named> @Unmodifiable Collection<T> filterWildcard(@NonNull Collection<T> inputValues, @NonNull String regex) {
        if (inputValues == null) {
            throw new NullPointerException("inputValues is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        return WildcardUtil.filterWildcard(inputValues, regex, true);
    }

    public static boolean anyMatch(@NonNull Collection<? extends Named> values, @NonNull String regex) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        return WildcardUtil.anyMatch(values, regex, true);
    }

    @NonNull
    public static <T extends Named> @Unmodifiable Collection<T> filterWildcard(@NonNull Collection<T> inputValues, @NonNull String regex, boolean caseSensitive) {
        if (inputValues == null) {
            throw new NullPointerException("inputValues is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        if (inputValues.isEmpty()) {
            return inputValues;
        }
        Pattern compiledPattern = WildcardUtil.fixPattern(regex, caseSensitive);
        return inputValues.stream().filter(data -> WildcardUtil.matches(regex, compiledPattern, data, caseSensitive)).toList();
    }

    public static boolean anyMatch(@NonNull Collection<? extends Named> values, @NonNull String regex, boolean caseSensitive) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        if (values.isEmpty()) {
            return false;
        }
        Pattern compiledPattern = WildcardUtil.fixPattern(regex, caseSensitive);
        return values.stream().anyMatch(data -> WildcardUtil.matches(regex, compiledPattern, data, caseSensitive));
    }

    @Nullable
    public static Pattern fixPattern(@NonNull String regex, boolean caseSensitive) {
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        regex = regex.replace("*", ".*");
        return WildcardUtil.tryCompile(regex, caseSensitive);
    }

    @Nullable
    private static Pattern tryCompile(@NonNull String pattern, boolean caseSensitive) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        try {
            return Pattern.compile(pattern, caseSensitive ? 0 : 2);
        }
        catch (PatternSyntaxException exception) {
            return WildcardUtil.tryFixPattern(exception, caseSensitive);
        }
        catch (StackOverflowError error) {
            return null;
        }
    }

    @Nullable
    private static Pattern tryFixPattern(@NonNull PatternSyntaxException exception, boolean caseSensitive) {
        if (exception == null) {
            throw new NullPointerException("exception is marked non-null but is null");
        }
        if (exception.getPattern() != null && exception.getIndex() != -1) {
            String pattern = exception.getPattern();
            if (exception.getDescription() != null && exception.getDescription().startsWith("Unclosed")) {
                String fixerResult = WildcardUtil.fixUnclosedGroups(pattern, exception.getIndex());
                if (fixerResult != null) {
                    return WildcardUtil.tryCompile(fixerResult, caseSensitive);
                }
            } else if (pattern.length() > exception.getIndex() + 1) {
                String firstPart = pattern.substring(0, exception.getIndex() + 1);
                String secondPart = pattern.substring(exception.getIndex() + 1);
                return WildcardUtil.tryCompile(firstPart + "\\" + secondPart, caseSensitive);
            }
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    static String fixUnclosedGroups(@NonNull String patternInput, int idx) {
        if (patternInput == null) {
            throw new NullPointerException("patternInput is marked non-null but is null");
        }
        if (idx < 0) {
            return null;
        }
        boolean done = false;
        StringBuilder result = new StringBuilder();
        char[] content = patternInput.toCharArray();
        for (int index = content.length - 1; index >= 0; --index) {
            char c = content[index];
            if (index > idx || done) {
                result.append(c);
                continue;
            }
            if (Arrays.binarySearch(GROUP_CHARS, c) >= 0 && WildcardUtil.isPartOfPattern(content, index)) {
                done = true;
                result.append(c).append("\\");
                continue;
            }
            result.append(c);
        }
        return result.reverse().toString();
    }

    private static boolean isPartOfPattern(char[] content, int index) {
        return index <= 0 || content[--index] != '\\';
    }

    private static boolean matches(@NonNull String patternInput, @Nullable Pattern compiled, @NonNull Named data, boolean caseSensitive) {
        if (patternInput == null) {
            throw new NullPointerException("patternInput is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (compiled == null) {
            return caseSensitive ? patternInput.equals(data.name()) : patternInput.equalsIgnoreCase(data.name());
        }
        return compiled.matcher(data.name()).matches();
    }
}

