/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.common.log.defaults;

import eu.cloudnetservice.common.log.LoggingUtil;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import lombok.NonNull;

public final class DefaultLogFormatter
extends Formatter {
    public static final DefaultLogFormatter END_CLEAN = new DefaultLogFormatter(false);
    public static final DefaultLogFormatter END_LINE_SEPARATOR = new DefaultLogFormatter(true);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd.MM HH:mm:ss.SSS");
    private final boolean closeWithLineSeparator;

    private DefaultLogFormatter(boolean closeWithLineSeparator) {
        this.closeWithLineSeparator = closeWithLineSeparator;
    }

    @Override
    @NonNull
    public String format(@NonNull LogRecord record) {
        if (record == null) {
            throw new NullPointerException("record is marked non-null but is null");
        }
        StringBuilder builder = new StringBuilder().append('[').append(DATE_TIME_FORMATTER.format(record.getInstant().atZone(ZoneId.systemDefault()))).append("] ").append(record.getLevel().getLocalizedName()).append(": ").append(super.formatMessage(record)).append(this.closeWithLineSeparator ? System.lineSeparator() : "");
        LoggingUtil.printStackTraceInto(builder, record);
        return builder.toString();
    }
}

