/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.common.log;

import eu.cloudnetservice.common.log.FallbackLoggerFactory;
import eu.cloudnetservice.common.log.Logger;
import eu.cloudnetservice.common.log.LoggerFactory;
import java.util.Iterator;
import java.util.ServiceLoader;
import lombok.NonNull;

public final class LogManager {
    private static final LoggerFactory LOGGER_FACTORY = LogManager.loadLoggerFactory();

    private LogManager() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static Logger rootLogger() {
        return LogManager.logger("");
    }

    @NonNull
    public static Logger logger(@NonNull Class<?> caller) {
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        return LogManager.logger(caller.getName());
    }

    @NonNull
    public static Logger logger(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return LogManager.loggerFactory().logger(name);
    }

    @NonNull
    public static LoggerFactory loggerFactory() {
        return LOGGER_FACTORY;
    }

    @NonNull
    private static LoggerFactory loadLoggerFactory() {
        Iterator<LoggerFactory> factories = ServiceLoader.load(LoggerFactory.class).iterator();
        if (factories.hasNext()) {
            return factories.next();
        }
        return new FallbackLoggerFactory();
    }
}

