/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.common.log;

import eu.cloudnetservice.common.log.LogManager;
import eu.cloudnetservice.common.log.LogRecordDispatcher;
import eu.cloudnetservice.common.log.Logger;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class FallbackPassthroughLogger
extends Logger {
    private final java.util.logging.Logger logger;
    private LogRecordDispatcher logRecordDispatcher;

    FallbackPassthroughLogger(@NonNull java.util.logging.Logger logger) {
        super(logger.getName(), logger.getResourceBundleName());
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        this.logger = logger;
    }

    @Override
    public void log(LogRecord record) {
        if (this.logRecordDispatcher == null) {
            this.logger.log(record);
        } else {
            this.logRecordDispatcher.dispatchRecord(this, record);
        }
    }

    @Override
    public void forceLog(@NonNull LogRecord logRecord) {
        if (logRecord == null) {
            throw new NullPointerException("logRecord is marked non-null but is null");
        }
        this.logger.log(logRecord);
    }

    @Override
    @Nullable
    public LogRecordDispatcher logRecordDispatcher() {
        return this.logRecordDispatcher;
    }

    @Override
    public void logRecordDispatcher(@Nullable LogRecordDispatcher dispatcher) {
        this.logRecordDispatcher = dispatcher;
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this.logger.getResourceBundle();
    }

    @Override
    public void setResourceBundle(ResourceBundle bundle) {
        this.logger.setResourceBundle(bundle);
    }

    @Override
    public String getResourceBundleName() {
        return this.logger.getResourceBundleName();
    }

    @Override
    public Filter getFilter() {
        return this.logger.getFilter();
    }

    @Override
    public void setFilter(Filter newFilter) throws SecurityException {
        this.logger.setFilter(newFilter);
    }

    @Override
    public Level getLevel() {
        Level thisLevel = this.logger.getLevel();
        return thisLevel == null ? LogManager.rootLogger().getLevel() : thisLevel;
    }

    @Override
    public void setLevel(Level newLevel) throws SecurityException {
        this.logger.setLevel(newLevel);
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    @Override
    public void addHandler(Handler handler) throws SecurityException {
        this.logger.addHandler(handler);
    }

    @Override
    public void removeHandler(Handler handler) throws SecurityException {
        this.logger.removeHandler(handler);
    }

    @Override
    public Handler[] getHandlers() {
        return this.logger.getHandlers();
    }

    @Override
    public boolean getUseParentHandlers() {
        return this.logger.getUseParentHandlers();
    }

    @Override
    public void setUseParentHandlers(boolean useParentHandlers) {
        this.logger.setUseParentHandlers(useParentHandlers);
    }

    @Override
    public java.util.logging.Logger getParent() {
        return this.logger.getParent();
    }

    @Override
    public void setParent(java.util.logging.Logger parent) {
        this.logger.setParent(parent);
    }
}

