/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.common.language;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.SetMultimap;
import eu.cloudnetservice.common.io.FileUtil;
import eu.cloudnetservice.common.log.LogManager;
import eu.cloudnetservice.common.log.Logger;
import eu.cloudnetservice.common.resource.ResourceResolver;
import io.vavr.CheckedConsumer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public final class I18n {
    private static final Pattern MESSAGE_FORMAT = Pattern.compile("\\{(.+?)\\$.+?\\$}");
    private static final Logger LOGGER = LogManager.logger(I18n.class);
    private static final SetMultimap<String, Entry> REGISTERED_ENTRIES = HashMultimap.create();
    private static final AtomicReference<String> CURRENT_LANGUAGE = new AtomicReference<String>("en_US");

    private I18n() {
        throw new UnsupportedOperationException();
    }

    public static void loadFromLangPath(@NonNull Class<?> clazzSource) {
        if (clazzSource == null) {
            throw new NullPointerException("clazzSource is marked non-null but is null");
        }
        Path resourcePath = Path.of(ResourceResolver.resolveCodeSourceOfClass(clazzSource));
        FileUtil.openZipFile(resourcePath, (CheckedConsumer<FileSystem>)((CheckedConsumer)fs -> {
            Path langDir = fs.getPath("lang/", new String[0]);
            if (Files.notExists(langDir, new LinkOption[0]) || !Files.isDirectory(langDir, new LinkOption[0])) {
                throw new IllegalStateException("lang/ must be an existing directory inside the jar to load");
            }
            FileUtil.walkFileTree(langDir, ($, sub) -> {
                try (InputStream stream = Files.newInputStream(sub, new OpenOption[0]);){
                    String lang = sub.getFileName().toString().replace(".properties", "");
                    I18n.addLanguageFile(lang, stream, clazzSource.getClassLoader());
                }
                catch (IOException exception) {
                    LOGGER.severe("Unable to open language file for reading @ %s", exception, sub);
                }
            }, false, "*.properties");
        }));
    }

    public static void addLanguageFile(@NonNull String lang, @NonNull Path file, @NonNull ClassLoader source) {
        if (lang == null) {
            throw new NullPointerException("lang is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
            I18n.addLanguageFile(lang, inputStream, source);
        }
        catch (IOException exception) {
            LOGGER.severe("Exception while reading language file", exception, new Object[0]);
        }
    }

    public static void addLanguageFile(@NonNull String lang, @NonNull InputStream stream, @NonNull ClassLoader source) {
        if (lang == null) {
            throw new NullPointerException("lang is marked non-null but is null");
        }
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
            Properties properties = new Properties();
            properties.load(reader);
            I18n.addLanguageFile(lang, properties, source);
        }
        catch (IOException exception) {
            LOGGER.severe("Exception while reading language file", exception, new Object[0]);
        }
    }

    public static void addLanguageFile(@NonNull String lang, @NonNull Properties entries, @NonNull ClassLoader source) {
        if (lang == null) {
            throw new NullPointerException("lang is marked non-null but is null");
        }
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        ImmutableMap.Builder messageFormats = ImmutableMap.builder();
        for (String key : entries.stringPropertyNames()) {
            String format = MESSAGE_FORMAT.matcher(entries.getProperty(key)).replaceAll("{$1}");
            messageFormats.put((Object)key, ThreadLocal.withInitial(() -> new MessageFormat(format, Locale.ROOT)));
        }
        REGISTERED_ENTRIES.put((Object)lang, (Object)new Entry(source, (Map<String, ThreadLocal<MessageFormat>>)messageFormats.build()));
        LOGGER.fine("Registering language file %s with %d translations", null, lang, entries.size());
    }

    public static void unregisterLanguageFiles(@NonNull ClassLoader loader) {
        if (loader == null) {
            throw new NullPointerException("loader is marked non-null but is null");
        }
        for (Map.Entry entry : REGISTERED_ENTRIES.entries()) {
            if (!((Entry)entry.getValue()).source().equals(loader)) continue;
            REGISTERED_ENTRIES.remove(entry.getKey(), entry.getValue());
        }
    }

    public static String trans(@NonNull String messageKey, Object ... args) {
        if (messageKey == null) {
            throw new NullPointerException("messageKey is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        Set entries = REGISTERED_ENTRIES.get((Object)I18n.language());
        if (entries.isEmpty()) {
            return String.format("<no language entry for %s>", I18n.language());
        }
        for (Entry entry : entries) {
            String result = entry.tryTranslate(messageKey, args);
            if (result == null) continue;
            return result;
        }
        return String.format("<no entry to translate \"%s\" in language \"%s\">", messageKey, I18n.language());
    }

    @NonNull
    public static String language() {
        return CURRENT_LANGUAGE.get();
    }

    @NonNull
    public static Collection<String> knownLanguages() {
        return REGISTERED_ENTRIES.keys();
    }

    public static void language(@NonNull String language) {
        if (language == null) {
            throw new NullPointerException("language is marked non-null but is null");
        }
        if (REGISTERED_ENTRIES.containsKey((Object)language)) {
            CURRENT_LANGUAGE.set(language);
        }
    }

    private record Entry(@NonNull ClassLoader source, @NonNull Map<String, ThreadLocal<MessageFormat>> languageEntries) {
        public Entry(@NonNull ClassLoader source, @NonNull Map<String, ThreadLocal<MessageFormat>> languageEntries) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            if (languageEntries == null) {
                throw new NullPointerException("languageEntries is marked non-null but is null");
            }
        }

        @Nullable
        public String tryTranslate(@NonNull String key, Object ... args) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (args == null) {
                throw new NullPointerException("args is marked non-null but is null");
            }
            ThreadLocal<MessageFormat> format = this.languageEntries.get(key);
            return format == null ? null : format.get().format(args);
        }
    }
}

