/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.common.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public class Task<V>
extends CompletableFuture<V> {
    private static final ExecutorService SERVICE = Executors.newCachedThreadPool();

    @NonNull
    public static <V> Task<V> supply(@NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        return Task.supply(() -> {
            runnable.run();
            return null;
        });
    }

    @NonNull
    public static <V> Task<V> supply(@NonNull Callable<V> supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        Task task = new Task();
        SERVICE.execute(() -> {
            try {
                task.complete(supplier.call());
            }
            catch (Exception exception) {
                task.completeExceptionally(exception);
            }
        });
        return task;
    }

    @NonNull
    public static <V> Task<V> wrapFuture(@NonNull CompletableFuture<V> future) {
        if (future == null) {
            throw new NullPointerException("future is marked non-null but is null");
        }
        Task task = new Task();
        future.whenComplete((T result, U exception) -> {
            if (exception == null) {
                task.complete(result);
            } else {
                task.completeExceptionally((Throwable)exception);
            }
        });
        return task;
    }

    @NonNull
    public static <V> Task<V> completedTask(@Nullable Object result) {
        Task<V> future = new Task<V>();
        if (result instanceof Throwable) {
            Throwable throwable = (Throwable)result;
            future.completeExceptionally(throwable);
        } else {
            future.complete(result);
        }
        return future;
    }

    public @UnknownNullability V getOrNull() {
        return this.getDef(null);
    }

    public @UnknownNullability V getDef(@Nullable V def) {
        try {
            return (V)this.join();
        }
        catch (CancellationException | CompletionException exception) {
            return def;
        }
    }

    public @UnknownNullability V get(long time, @NonNull TimeUnit timeUnit, @Nullable V def) {
        if (timeUnit == null) {
            throw new NullPointerException("timeUnit is marked non-null but is null");
        }
        try {
            return (V)this.get(time, timeUnit);
        }
        catch (InterruptedException | CancellationException | ExecutionException | TimeoutException exception) {
            return def;
        }
    }
}

