/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.common.concurrent;

import eu.cloudnetservice.common.concurrent.Task;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;

public class ListenableTask<V>
extends Task<V> {
    protected static final int STATE_NEW = 0;
    protected static final int STATE_RUN = 1;
    protected static final int STATE_DONE = 2;
    private final Callable<V> callable;
    private final AtomicInteger state = new AtomicInteger(0);

    public ListenableTask(@NonNull Callable<V> callable) {
        if (callable == null) {
            throw new NullPointerException("callable is marked non-null but is null");
        }
        this.callable = callable;
    }

    public void run(boolean setResult) {
        if (this.state.compareAndSet(0, 1)) {
            try {
                V result = this.callable.call();
                if (setResult) {
                    this.complete(result);
                    this.state.setRelease(2);
                } else {
                    this.state.set(0);
                }
            }
            catch (Throwable throwable) {
                this.completeExceptionally(throwable);
                this.state.setRelease(2);
            }
        }
    }
}

