/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.common.resource;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import lombok.NonNull;

public final class ResourceFormatter {
    private static final long ONE_MB_IN_BYTES = 0x100000L;
    private static final ThreadLocal<DecimalFormat> DECIMAL_FORMAT_2DIGIT_PRECISION = ThreadLocal.withInitial(() -> new DecimalFormat(".##", DecimalFormatSymbols.getInstance(Locale.ROOT)));

    private ResourceFormatter() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static String formatTwoDigitPrecision(double value) {
        DecimalFormat decimalFormat = DECIMAL_FORMAT_2DIGIT_PRECISION.get();
        return decimalFormat.format(value);
    }

    public static double convertToPercentage(double value) {
        if (value == 0.0) {
            return 0.0;
        }
        if (value < 0.0) {
            return -1.0;
        }
        return Math.min(100.0, value * 100.0);
    }

    public static long convertBytesToMb(long bytesToConvert) {
        return bytesToConvert / 0x100000L;
    }
}

