/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.common.log.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public final class LogOutputStream
extends ByteArrayOutputStream {
    public static final boolean DEFAULT_AUTO_FLUSH = true;
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final Level level;
    private final Logger logger;
    private final Lock flushLock;

    private LogOutputStream(@NonNull Level level, @NonNull Logger logger) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        this.level = level;
        this.logger = logger;
        this.flushLock = new ReentrantLock();
    }

    @NonNull
    public static LogOutputStream forWarn(@NonNull Logger logger) {
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        return LogOutputStream.newInstance(logger, Level.WARN);
    }

    @NonNull
    public static LogOutputStream forInfo(@NonNull Logger logger) {
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        return LogOutputStream.newInstance(logger, Level.INFO);
    }

    @NonNull
    public static LogOutputStream newInstance(@NonNull Logger logger, @NonNull Level level) {
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        return new LogOutputStream(level, logger);
    }

    @NonNull
    public PrintStream toPrintStream() {
        return this.toPrintStream(true, DEFAULT_CHARSET);
    }

    @NonNull
    public PrintStream toPrintStream(boolean autoFlush, @NonNull Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        return new PrintStream((OutputStream)this, autoFlush, charset);
    }

    @Override
    public void flush() throws IOException {
        this.flushLock.lock();
        try {
            super.flush();
            String content = this.toString(StandardCharsets.UTF_8).stripTrailing();
            super.reset();
            if (!content.isEmpty()) {
                this.logger.atLevel(this.level).log(content);
            }
        }
        finally {
            this.flushLock.unlock();
        }
    }
}

