/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.common.util;

import com.google.common.base.Preconditions;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import lombok.NonNull;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class StringUtil {
    private static final Random SECURE_RANDOM = new SecureRandom();
    private static final char[] DEFAULT_ALPHABET_UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();

    private StringUtil() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static String generateRandomString(int length) {
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"Can only generate string which is longer to 0 chars");
        StringBuilder buffer = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int nextCharIdx = SECURE_RANDOM.nextInt(DEFAULT_ALPHABET_UPPERCASE.length);
            buffer.append(DEFAULT_ALPHABET_UPPERCASE[nextCharIdx]);
        }
        return buffer.toString();
    }

    public static boolean endsWithIgnoreCase(@NonNull String string, @NonNull String suffix) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        int suffixLength = suffix.length();
        return string.regionMatches(true, string.length() - suffixLength, suffix, 0, suffixLength);
    }

    public static boolean startsWithIgnoreCase(@NonNull String string, @NonNull String prefix) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        return string.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    @Contract(value="!null -> !null; null -> null")
    @Nullable
    public static String toLower(@Nullable String string) {
        return string == null ? null : string.toLowerCase(Locale.ROOT);
    }

    @Contract(value="!null -> !null; null -> null")
    @Nullable
    public static String toUpper(@Nullable String string) {
        return string == null ? null : string.toUpperCase(Locale.ROOT);
    }

    @NonNull
    public static String repeat(char c, int times) {
        Preconditions.checkArgument((times >= 0 ? 1 : 0) != 0, (Object)"Can only copy a char 0 or more times, not negative times");
        if (times == 0) {
            return "";
        }
        if (times == 1) {
            return Character.toString(c);
        }
        char[] s = new char[times];
        Arrays.fill(s, c);
        return new String(s);
    }
}

