/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.common.log.defaults;

import eu.cloudnetservice.common.log.LogRecordDispatcher;
import eu.cloudnetservice.common.log.Logger;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.LogRecord;
import lombok.NonNull;

public final class ThreadedLogRecordDispatcher
extends Thread
implements LogRecordDispatcher {
    public static final String THREAD_NAME_FORMAT = "Log record dispatcher %s";
    private final Logger logger;
    private final BlockingQueue<LogRecord> queue;

    private ThreadedLogRecordDispatcher(@NonNull Logger logger, @NonNull String threadName) {
        super(threadName);
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        if (threadName == null) {
            throw new NullPointerException("threadName is marked non-null but is null");
        }
        this.setDaemon(true);
        this.setPriority(1);
        this.logger = logger;
        this.queue = new LinkedBlockingQueue<LogRecord>();
        this.start();
    }

    @NonNull
    public static ThreadedLogRecordDispatcher forLogger(@NonNull Logger logger) {
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        return ThreadedLogRecordDispatcher.newInstance(logger, String.format(THREAD_NAME_FORMAT, logger.getName()));
    }

    @NonNull
    public static ThreadedLogRecordDispatcher newInstance(@NonNull Logger logger, @NonNull String threadName) {
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        if (threadName == null) {
            throw new NullPointerException("threadName is marked non-null but is null");
        }
        return new ThreadedLogRecordDispatcher(logger, threadName);
    }

    @Override
    public void dispatchRecord(@NonNull Logger logger, @NonNull LogRecord record) {
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        if (record == null) {
            throw new NullPointerException("record is marked non-null but is null");
        }
        if (!super.isInterrupted()) {
            this.queue.add(record);
        }
    }

    @Override
    public void run() {
        while (!super.isInterrupted()) {
            try {
                LogRecord logRecord = this.queue.take();
                this.logger.forceLog(logRecord);
            }
            catch (InterruptedException exception) {
                // empty catch block
                break;
            }
        }
        for (LogRecord logRecord : this.queue) {
            this.logger.forceLog(logRecord);
        }
        Thread.currentThread().interrupt();
    }
}

