/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.common.log.defaults;

import eu.cloudnetservice.common.io.FileUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import lombok.NonNull;

public final class DefaultFileHandler
extends FileHandler {
    public static final int DEFAULT_COUNT = 8;
    public static final int DEFAULT_LIMIT = 0x400000;

    private DefaultFileHandler(@NonNull String pattern, int limit, int count, boolean append) throws IOException {
        super(pattern, limit, count, append);
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        this.setLevel(Level.ALL);
        this.setEncoding(StandardCharsets.UTF_8.name());
    }

    @NonNull
    public static DefaultFileHandler newInstance(@NonNull String pattern, boolean append) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DefaultFileHandler.newInstance(pattern, 0x400000, 8, append);
    }

    @NonNull
    public static DefaultFileHandler newInstance(@NonNull String pattern, int limit, int count, boolean append) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DefaultFileHandler.newInstance(Path.of(pattern, new String[0]), limit, count, append);
    }

    @NonNull
    public static DefaultFileHandler newInstance(@NonNull Path pattern, boolean append) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return DefaultFileHandler.newInstance(pattern, 0x400000, 8, append);
    }

    @NonNull
    public static DefaultFileHandler newInstance(@NonNull Path pattern, int limit, int count, boolean append) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        try {
            FileUtil.createDirectory(pattern.getParent());
            return new DefaultFileHandler(pattern.toAbsolutePath().toString(), limit, count, append);
        }
        catch (IOException exception) {
            throw new IllegalStateException("Unable to create file handler instance", exception);
        }
    }

    @NonNull
    public DefaultFileHandler withFormatter(@NonNull Formatter formatter) {
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        super.setFormatter(formatter);
        return this;
    }
}

