/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.common.log.defaults;

import eu.cloudnetservice.common.log.AbstractHandler;
import java.util.function.Consumer;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import lombok.NonNull;

public final class AcceptingLogHandler
extends AbstractHandler {
    private final Consumer<String> handler;

    private AcceptingLogHandler(@NonNull Consumer<String> handler) {
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        this.handler = handler;
        this.setLevel(Level.ALL);
    }

    @NonNull
    public static AcceptingLogHandler newInstance(@NonNull Consumer<String> handler) {
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        return new AcceptingLogHandler(handler);
    }

    @Override
    public void publish(LogRecord record) {
        if (super.isLoggable(record)) {
            this.handler.accept(super.getFormatter().format(record));
        }
    }

    @NonNull
    public AcceptingLogHandler withFormatter(@NonNull Formatter formatter) {
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        super.setFormatter(formatter);
        return this;
    }
}

