/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.common.log;

import eu.cloudnetservice.common.log.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import lombok.NonNull;

public final class LoggingUtil {
    private LoggingUtil() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static Level defaultLogLevel() {
        String defaultLogLevel = System.getProperty("cloudnet.logging.defaultlevel");
        if (defaultLogLevel == null) {
            return Level.INFO;
        }
        try {
            return Level.parse(defaultLogLevel);
        }
        catch (IllegalArgumentException exception) {
            return Level.INFO;
        }
    }

    public static void removeHandlers(@NonNull Logger logger) {
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
    }

    public static void printStackTraceInto(@NonNull StringBuilder stringBuilder, @NonNull LogRecord record) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        if (record == null) {
            throw new NullPointerException("record is marked non-null but is null");
        }
        if (record.getThrown() != null) {
            StringWriter writer = new StringWriter();
            record.getThrown().printStackTrace(new PrintWriter(writer));
            stringBuilder.append('\n').append(writer);
        }
    }
}

