/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.common.log;

import eu.cloudnetservice.common.log.FallbackPassthroughLogger;
import eu.cloudnetservice.common.log.Logger;
import eu.cloudnetservice.common.log.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogManager;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
final class FallbackLoggerFactory
implements LoggerFactory {
    private final Map<String, Logger> createdLoggers = new HashMap<String, Logger>();

    FallbackLoggerFactory() {
    }

    @Override
    @NonNull
    public Logger logger(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        java.util.logging.Logger registered = LogManager.getLogManager().getLogger(name);
        if (registered instanceof Logger) {
            Logger logger = (Logger)registered;
            return logger;
        }
        return this.createdLoggers.computeIfAbsent(name, $ -> {
            if (registered == null) {
                java.util.logging.Logger julComputedLoggerInstance = Logger.getLogger(name);
                return new FallbackPassthroughLogger(julComputedLoggerInstance);
            }
            return new FallbackPassthroughLogger(registered);
        });
    }
}

