/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.common.concurrent;

import eu.cloudnetservice.common.concurrent.Task;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public class CountingTask<V>
extends Task<V> {
    private final V resultValue;
    private final AtomicInteger count;

    public CountingTask(@Nullable V resultValue, int initialCount) {
        if (initialCount <= 0) {
            this.complete(resultValue);
            this.count = null;
            this.resultValue = null;
        } else {
            this.resultValue = resultValue;
            this.count = new AtomicInteger(initialCount);
        }
    }

    public void countUp() {
        this.count.incrementAndGet();
        this.publishCountChange();
    }

    public void countDown() {
        this.count.decrementAndGet();
        this.publishCountChange();
    }

    public void countTo(int target) {
        this.count.set(target);
        this.publishCountChange();
    }

    public int count() {
        return this.count.get();
    }

    protected void publishCountChange() {
        if (this.count() <= 0) {
            this.complete(this.resultValue);
        }
    }
}

