/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.java;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.codehaus.janino.DebuggingInformation;
import org.codehaus.janino.EvaluatorBase;
import org.codehaus.janino.Java;
import org.codehaus.janino.Location;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.util.PrimitiveWrapper;
import org.drools.rule.Declaration;
import org.drools.semantics.base.ClassObjectType;
import org.drools.spi.Importer;
import org.drools.spi.ObjectType;

public class JavaScriptEvaluator
extends EvaluatorBase {
    private final Method method;

    public Method getMethod() {
        return this.method;
    }

    public JavaScriptEvaluator(String code, String className, Class interfaceToImplement, String[] parameterNames, Declaration[] declarations, Importer importer, Map applicationData, Class baseClass, ClassLoader classLoader) throws Scanner.ScanException, Parser.ParseException, Java.CompileException, IOException, ClassNotFoundException {
        super(classLoader);
        Scanner scanner = new Scanner(null, (Reader)new StringReader(code));
        Method[] methods = interfaceToImplement.getDeclaredMethods();
        if (methods.length != 1) {
            throw new RuntimeException("Interface \"" + interfaceToImplement + "\" must declare exactly one method");
        }
        Method methodToImplement = methods[0];
        String methodName = methodToImplement.getName();
        Class[] parameterTypes = methodToImplement.getParameterTypes();
        if (parameterNames.length != parameterTypes.length) {
            throw new RuntimeException("Lengths of \"parameterNames\" and \"parameterTypes\" do not match");
        }
        Java.CompilationUnit compilationUnit = new Java.CompilationUnit(scanner.peek().getLocation().getFileName());
        this.parseImportDeclarations(compilationUnit, scanner);
        Java.Block block = this.addClassMethodBlockDeclaration(scanner.peek().getLocation(), compilationUnit, className, baseClass, new Class[]{interfaceToImplement}, false, methodToImplement.getReturnType(), methodName, parameterNames, parameterTypes, methodToImplement.getExceptionTypes());
        HashSet imports = new HashSet(importer.getImports());
        Parser parser = new Parser(scanner);
        this.addDeclarations(scanner, block, declarations, imports);
        this.addAppData(scanner, block, applicationData, imports);
        Location loc = scanner.peek().getLocation();
        Iterator it = imports.iterator();
        while (it.hasNext()) {
            boolean importOnDemand = false;
            ArrayList<String> list = new ArrayList<String>();
            String type = (String)it.next();
            StringTokenizer st = new StringTokenizer(type, ".");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!token.equals("*")) {
                    list.add(token);
                    continue;
                }
                importOnDemand = true;
            }
            if (importOnDemand) {
                compilationUnit.addImportDeclaration((Java.ImportDeclaration)new Java.TypeImportOnDemandDeclaration(loc, list.toArray(new String[list.size()])));
                continue;
            }
            compilationUnit.addImportDeclaration((Java.ImportDeclaration)new Java.SingleTypeImportDeclaration(loc, list.toArray(new String[list.size()])));
        }
        while (!scanner.peek().isEOF()) {
            block.addStatement(parser.parseBlockStatement(block));
        }
        Class c = this.compileAndLoad(compilationUnit, DebuggingInformation.ALL, className);
        try {
            this.method = c.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex.toString());
        }
        if (this.method == null) {
            throw new RuntimeException("Method \"" + methodName + "\" not found");
        }
    }

    private void addAppData(Scanner scanner, Java.Block block, Map appData, Set imports) {
        Set keys = appData.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            Class clazz = (Class)appData.get(key);
            String type = clazz.getName();
            int nestedClassPosition = type.indexOf(36);
            if (nestedClassPosition != -1) {
                type = type.substring(0, nestedClassPosition);
            }
            imports.add(type);
            Location loc = scanner.peek().getLocation();
            Java.VariableDeclarator[] variables = new Java.VariableDeclarator[]{new Java.VariableDeclarator(loc, key, 0, (Java.Rvalue)new Java.Cast(loc, this.classToType(loc, clazz), (Java.Rvalue)new Java.MethodInvocation(loc, (Java.Scope)block, (Java.Atom)new Java.AmbiguousName(loc, (Java.Scope)block, new String[]{"applicationData"}), "get", new Java.Rvalue[]{new Java.Literal(loc, (Object)key)})))};
            block.addStatement((Java.BlockStatement)new Java.LocalVariableDeclarationStatement(loc, block, 16, this.classToType(loc, clazz), variables));
        }
    }

    private void addDeclarations(Scanner scanner, Java.Block block, Declaration[] declarations, Set imports) {
        for (int i = 0; i < declarations.length; ++i) {
            Declaration declaration = declarations[i];
            String identifier = declaration.getIdentifier();
            ObjectType objectType = declaration.getObjectType();
            Class clazz = ((ClassObjectType)objectType).getType();
            String type = clazz.getName();
            int nestedClassPosition = type.indexOf(36);
            if (nestedClassPosition != -1) {
                type = type.substring(0, nestedClassPosition);
            }
            imports.add(type);
            Location loc = scanner.peek().getLocation();
            Java.VariableDeclarator[] variables = new Java.VariableDeclarator[]{new Java.VariableDeclarator(loc, identifier, 0, (Java.Rvalue)new Java.Cast(loc, this.classToType(loc, clazz), (Java.Rvalue)new Java.MethodInvocation(loc, (Java.Scope)block, (Java.Atom)new Java.AmbiguousName(loc, (Java.Scope)block, new String[]{"tuple"}), "get", new Java.Rvalue[]{new Java.ArrayAccessExpression(loc, (Java.Rvalue)new Java.AmbiguousName(loc, (Java.Scope)block, new String[]{"decls"}), (Java.Rvalue)new Java.ConstantValue(loc, (Object)PrimitiveWrapper.wrap((int)i)))})))};
            block.addStatement((Java.BlockStatement)new Java.LocalVariableDeclarationStatement(loc, block, 16, this.classToType(loc, clazz), variables));
        }
    }

    public static Object compile(String block, String className, Class interfaceToImplement, String[] parameterNames, Declaration[] declarations, Importer importer, Map applicationData, Class baseClass, ClassLoader classLoader) throws Scanner.ScanException, Parser.ParseException, Java.CompileException, IOException, ClassNotFoundException {
        JavaScriptEvaluator scriptEvaluator = new JavaScriptEvaluator(block, className, interfaceToImplement, parameterNames, declarations, importer, applicationData, baseClass, classLoader);
        try {
            return scriptEvaluator.getMethod().getDeclaringClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.toString());
        }
    }
}

