/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io;

import java.util.HashSet;
import org.drools.io.BaseAbstractHandler;
import org.drools.io.Handler;
import org.drools.io.RuleSetReader;
import org.drools.rule.ApplicationData;
import org.drools.rule.Rule;
import org.drools.rule.RuleConstructionException;
import org.drools.rule.RuleSet;
import org.drools.smf.Configuration;
import org.drools.smf.FactoryException;
import org.drools.smf.RuleFactory;
import org.drools.smf.SemanticModule;
import org.drools.spi.Functions;
import org.drools.spi.ImportEntry;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class RuleHandler
extends BaseAbstractHandler
implements Handler {
    RuleHandler(RuleSetReader ruleSetReader) {
        this.ruleSetReader = ruleSetReader;
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(RuleSet.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(Rule.class);
            this.validPeers.add(ImportEntry.class);
            this.validPeers.add(ApplicationData.class);
            this.validPeers.add(Functions.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs) throws SAXException {
        Rule rule;
        SemanticModule module = this.ruleSetReader.lookupSemanticModule(uri, localName);
        RuleFactory factory = module.getRuleFactory(localName);
        this.ruleSetReader.startConfiguration(localName, attrs);
        Configuration config = this.ruleSetReader.endConfiguration();
        try {
            rule = factory.newRule(this.ruleSetReader.getRuleSet(), this.ruleSetReader.getFactoryContext(), config);
            this.startRule(rule, attrs);
        }
        catch (FactoryException e) {
            throw new SAXParseException("error constructing rule", this.ruleSetReader.getLocator(), (Exception)((Object)e));
        }
        return rule;
    }

    private void startRule(Rule rule, Attributes attrs) throws SAXException {
        String salienceStr = attrs.getValue("salience");
        String noLoopStr = attrs.getValue("no-loop");
        String xorGroup = attrs.getValue("xor-group");
        String ruleDesc = attrs.getValue("description");
        if (salienceStr != null && !salienceStr.trim().equals("")) {
            try {
                int salience = Integer.parseInt(salienceStr.trim());
                rule.setSalience(salience);
            }
            catch (NumberFormatException e) {
                throw new SAXParseException("invalid number value for 'salience' attribute: " + salienceStr.trim(), this.ruleSetReader.getLocator());
            }
        }
        if (noLoopStr != null && !noLoopStr.trim().equals("")) {
            try {
                boolean noLoop = new Boolean(noLoopStr.trim());
                rule.setNoLoop(noLoop);
            }
            catch (NumberFormatException e) {
                throw new SAXParseException("invalid boolean value for 'no-loop' attribute: " + salienceStr.trim(), this.ruleSetReader.getLocator());
            }
        }
        if (ruleDesc != null && !ruleDesc.trim().equals("")) {
            rule.setXorGroup(xorGroup);
        }
        if (ruleDesc != null && !ruleDesc.trim().equals("")) {
            rule.setDocumentation(ruleDesc);
        }
        rule.setImporter(this.ruleSetReader.getRuleSet().getImporter());
        rule.setApplicationData(this.ruleSetReader.getRuleSet().getApplicationData());
    }

    public Object end(String uri, String localName) throws SAXException {
        try {
            this.ruleSetReader.getRuleSet().addRule((Rule)this.ruleSetReader.getParents().getLast());
        }
        catch (RuleConstructionException e) {
            throw new SAXParseException("error adding rule", this.ruleSetReader.getLocator(), (Exception)((Object)e));
        }
        return null;
    }

    public Class generateNodeFor() {
        return Rule.class;
    }
}

