/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io;

import java.util.HashSet;
import org.drools.io.BaseAbstractHandler;
import org.drools.io.Handler;
import org.drools.io.RuleSetReader;
import org.drools.rule.Declaration;
import org.drools.rule.InvalidRuleException;
import org.drools.rule.Rule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ParameterHandler
extends BaseAbstractHandler
implements Handler {
    ParameterHandler(RuleSetReader ruleSetReader) {
        this.ruleSetReader = ruleSetReader;
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(Rule.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(Declaration.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs) throws SAXException {
        Rule rule = (Rule)this.ruleSetReader.getParent(Rule.class);
        String identifier = attrs.getValue("identifier");
        if (identifier == null || identifier.trim().equals("")) {
            throw new SAXParseException("<parameter> requires an 'identifier' attribute", this.ruleSetReader.getLocator());
        }
        identifier = identifier.trim();
        try {
            return rule.addParameterDeclaration(identifier, null);
        }
        catch (InvalidRuleException e) {
            throw new SAXParseException("'" + identifier + "' is already defined", this.ruleSetReader.getLocator());
        }
    }

    public Object end(String uri, String localName) throws SAXException {
        Declaration declaration = (Declaration)this.ruleSetReader.getCurrent();
        Rule rule = (Rule)this.ruleSetReader.getParent(Rule.class);
        if (rule == null || declaration == null) {
            throw new SAXParseException("unable to construct <parameter>", this.ruleSetReader.getLocator());
        }
        if (declaration.getObjectType() == null) {
            throw new SAXParseException("<parameter> requires an object-type", this.ruleSetReader.getLocator());
        }
        return null;
    }

    public Class generateNodeFor() {
        return Declaration.class;
    }
}

