/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io;

import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.drools.io.DefaultConfiguration;
import org.drools.rule.Declaration;
import org.drools.rule.Extraction;
import org.drools.rule.Rule;
import org.drools.rule.RuleConstructionException;
import org.drools.rule.RuleSet;
import org.drools.smf.ConditionFactory;
import org.drools.smf.Configuration;
import org.drools.smf.ConsequenceFactory;
import org.drools.smf.DefaultSemanticsRepository;
import org.drools.smf.ExtractorFactory;
import org.drools.smf.FactoryException;
import org.drools.smf.NoSuchSemanticModuleException;
import org.drools.smf.ObjectTypeFactory;
import org.drools.smf.RuleFactory;
import org.drools.smf.SemanticModule;
import org.drools.smf.SemanticsRepository;
import org.drools.spi.Condition;
import org.drools.spi.Consequence;
import org.drools.spi.Extractor;
import org.drools.spi.ObjectType;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class RuleSetReader
extends DefaultHandler {
    public static final String RULES_NAMESPACE_URI = "http://drools.org/rules";
    private static final int STATE_NONE = 0;
    private static final int STATE_OBJECT_TYPE = 2;
    private static final int STATE_CONDITION = 3;
    private static final int STATE_EXTRACTION = 4;
    private static final int STATE_CONSEQUENCE = 5;
    private int state = 0;
    private SAXParser parser;
    private Locator locator;
    private RuleSet ruleSet;
    private Rule rule;
    private Declaration declaration;
    private Extraction extraction;
    private LinkedList configurationStack;
    private StringBuffer characters;
    private Map starters = new HashMap();
    private Map enders = new HashMap();
    private SemanticsRepository repo;

    public RuleSetReader() {
        this.configurationStack = new LinkedList();
        this.bindStarter(RULES_NAMESPACE_URI, "rule-set", new Starter(){

            void start(Attributes attrs) throws SAXException {
                RuleSetReader.this.startRuleSet(attrs);
            }
        });
        this.bindEnder(RULES_NAMESPACE_URI, "rule-set", new Ender(){

            void end() throws SAXException {
                RuleSetReader.this.endRuleSet();
            }
        });
        this.bindStarter(RULES_NAMESPACE_URI, "parameter", new Starter(){

            void start(Attributes attrs) throws SAXException {
                RuleSetReader.this.startParameter(attrs);
            }
        });
        this.bindEnder(RULES_NAMESPACE_URI, "parameter", new Ender(){

            void end() throws SAXException {
                RuleSetReader.this.endParameter();
            }
        });
        this.bindStarter(RULES_NAMESPACE_URI, "declaration", new Starter(){

            void start(Attributes attrs) throws SAXException {
                RuleSetReader.this.startParameter(attrs);
            }
        });
        this.bindEnder(RULES_NAMESPACE_URI, "declaration", new Ender(){

            void end() throws SAXException {
                RuleSetReader.this.endDeclaration();
            }
        });
    }

    public RuleSetReader(SAXParser parser) {
        this();
        this.parser = parser;
    }

    public RuleSetReader(SemanticsRepository repo, SAXParser parser) {
        this(parser);
        this.repo = repo;
    }

    public RuleSetReader(SemanticsRepository repo) {
        this();
        this.repo = repo;
    }

    public RuleSet read(URL url) throws Exception {
        return this.read(new InputSource(url.toExternalForm()));
    }

    public RuleSet read(Reader reader) throws Exception {
        return this.read(new InputSource(reader));
    }

    public RuleSet read(InputStream inputStream) throws Exception {
        return this.read(new InputSource(inputStream));
    }

    public RuleSet read(String url) throws Exception {
        return this.read(new InputSource(url));
    }

    public RuleSet read(InputSource in) throws Exception {
        SAXParser parser = null;
        if (this.parser == null) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            parser = factory.newSAXParser();
        } else {
            parser = this.parser;
        }
        if (this.repo == null) {
            try {
                this.repo = DefaultSemanticsRepository.getInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        parser.parse(in, (DefaultHandler)this);
        return this.ruleSet;
    }

    public void setLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void startElement(String uri, String localName, String qname, Attributes attrs) throws SAXException {
        block11: {
            Starter starter = this.lookupStarter(uri, localName);
            if (starter != null) {
                starter.start(attrs);
            } else {
                try {
                    SemanticModule module = this.repo.lookupSemanticModule(uri);
                    if (this.rule == null) {
                        if (module.getRuleFactoryNames().contains(localName)) {
                            this.startRule(module, localName, attrs);
                            break block11;
                        }
                        throw new SAXParseException("unknown tag '" + localName + "' in namespace '" + uri + "'", this.getLocator());
                    }
                    if (this.declaration != null) {
                        if (module.getObjectTypeFactoryNames().contains(localName)) {
                            this.startObjectType(module, localName, attrs);
                            break block11;
                        }
                        throw new SAXParseException("unknown tag '" + localName + "' in namespace '" + uri + "'", this.getLocator());
                    }
                    if (module.getConditionFactoryNames().contains(localName)) {
                        this.startCondition(module, localName, attrs);
                        break block11;
                    }
                    if (module.getExtractorFactoryNames().contains(localName)) {
                        this.startExtraction(module, localName, attrs);
                        break block11;
                    }
                    if (module.getConsequenceFactoryNames().contains(localName)) {
                        this.startConsequence(module, localName, attrs);
                        break block11;
                    }
                    throw new SAXParseException("unknown tag '" + localName + "' in namespace '" + uri + "'", this.getLocator());
                }
                catch (NoSuchSemanticModuleException e) {
                    throw new SAXParseException("no semantic module for namespace '" + uri + "' (" + localName + ")", this.getLocator());
                }
            }
        }
    }

    public void endElement(String uri, String localName, String qname) throws SAXException {
        Ender ender = this.lookupEnder(uri, localName);
        if (ender != null) {
            ender.end();
        } else if (this.configurationStack.size() <= 1) {
            try {
                SemanticModule module = this.repo.lookupSemanticModule(uri);
                switch (this.state) {
                    case 2: {
                        this.endObjectType(module, localName);
                        break;
                    }
                    case 3: {
                        this.endCondition(module, localName);
                        break;
                    }
                    case 4: {
                        this.endExtraction(module, localName);
                        break;
                    }
                    case 5: {
                        this.endConsequence(module, localName);
                        break;
                    }
                    default: {
                        this.endRule();
                        break;
                    }
                }
            }
            catch (NoSuchSemanticModuleException e) {
                throw new SAXParseException("no semantic module for namespace '" + uri + "' (" + localName + ")", this.getLocator());
            }
        } else {
            this.endConfiguration();
        }
    }

    protected void startRuleSet(Attributes attrs) throws SAXException {
        if (this.ruleSet != null) {
            throw new SAXParseException("<rule-set> may not be nested", this.getLocator());
        }
        String ruleSetName = attrs.getValue("name");
        if (ruleSetName == null || ruleSetName.trim().equals("")) {
            throw new SAXParseException("<rule-set> requires a 'name' attribute", this.getLocator());
        }
        this.ruleSet = new RuleSet(ruleSetName.trim());
    }

    protected void endRuleSet() throws SAXException {
    }

    protected void startRule(SemanticModule module, String localName, Attributes attrs) throws SAXException {
        RuleFactory factory = module.getRuleFactory(localName);
        this.startConfiguration(localName, attrs);
        Configuration config = this.endConfiguration();
        try {
            this.rule = factory.newRule(config);
            this.startRule(this.rule, attrs);
        }
        catch (FactoryException e) {
            throw new SAXParseException("error constructing rule", this.getLocator(), (Exception)((Object)e));
        }
    }

    protected void startRule(Rule rule, Attributes attrs) throws SAXException {
        String salienceStr = attrs.getValue("salience");
        if (salienceStr != null && !salienceStr.trim().equals("")) {
            try {
                int salience = Integer.parseInt(salienceStr.trim());
                rule.setSalience(salience);
            }
            catch (NumberFormatException e) {
                throw new SAXParseException("invalid number value for 'salience' attribute: " + salienceStr.trim(), this.getLocator());
            }
        }
    }

    protected void endRule() throws SAXException {
        try {
            this.ruleSet.addRule(this.rule);
            this.rule = null;
        }
        catch (RuleConstructionException e) {
            throw new SAXParseException("error adding rule", this.getLocator(), (Exception)((Object)e));
        }
    }

    protected void startParameter(Attributes attrs) throws SAXException {
        this.startParameterOrDeclaration("parameter", attrs);
    }

    protected void endParameter() throws SAXException {
        if (this.declaration.getObjectType() == null) {
            throw new SAXParseException("<parameter> requires an object-type", this.getLocator());
        }
        this.rule.addParameterDeclaration(this.declaration);
        this.declaration = null;
    }

    protected void startDeclaration(Attributes attrs) throws SAXException {
        this.startParameterOrDeclaration("declaration", attrs);
    }

    protected void endDeclaration() throws SAXException {
        if (this.declaration.getObjectType() == null) {
            throw new SAXParseException("<declaration> requires an object-type", this.getLocator());
        }
        this.rule.addDeclaration(this.declaration);
        this.declaration = null;
    }

    private void startParameterOrDeclaration(String tagName, Attributes attrs) throws SAXException {
        if (this.rule == null) {
            throw new SAXParseException("<" + tagName + "> must occur within a <rule>", this.getLocator());
        }
        String identifier = attrs.getValue("identifier");
        if (identifier == null || identifier.trim().equals("")) {
            throw new SAXParseException("<" + tagName + "> requires an 'identifier' attribute", this.getLocator());
        }
        this.declaration = new Declaration(identifier.trim());
    }

    protected void startObjectType(SemanticModule module, String localName, Attributes attrs) throws SAXException {
        this.state = 2;
        this.startConfiguration(localName, attrs);
    }

    protected void endObjectType(SemanticModule module, String localName) throws SAXException {
        Configuration config = this.endConfiguration();
        ObjectTypeFactory factory = module.getObjectTypeFactory(localName);
        try {
            try {
                ObjectType objectType = factory.newObjectType(config);
                this.declaration.setObjectType(objectType);
            }
            catch (FactoryException e) {
                throw new SAXParseException("error constructing object type", this.getLocator(), (Exception)((Object)e));
            }
            Object var7_7 = null;
            this.state = 0;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.state = 0;
            throw throwable;
        }
    }

    protected void startExtraction(SemanticModule module, String localName, Attributes attrs) throws SAXException {
        this.state = 4;
        String targetDeclName = attrs.getValue("target");
        if (targetDeclName == null || targetDeclName.trim().equals("")) {
            throw new SAXParseException("extraction requires a 'target' attribute", this.getLocator());
        }
        Declaration targetDecl = this.rule.getDeclaration(targetDeclName.trim());
        if (targetDecl == null) {
            throw new SAXParseException("'" + targetDeclName + "' is not a valid declaration", this.getLocator());
        }
        this.extraction = new Extraction(targetDecl);
        this.startConfiguration(localName, attrs);
    }

    protected void endExtraction(SemanticModule module, String localName) throws SAXException {
        Configuration config = this.endConfiguration();
        ExtractorFactory factory = module.getExtractorFactory(localName);
        try {
            try {
                Extractor extractor = factory.newExtractor(config, this.rule.getAllDeclarations());
                this.extraction.setExtractor(extractor);
                this.rule.addExtraction(this.extraction);
                this.extraction = null;
            }
            catch (FactoryException e) {
                throw new SAXParseException("error constructing extractor", this.getLocator(), (Exception)((Object)e));
            }
            Object var7_7 = null;
            this.state = 0;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.state = 0;
            throw throwable;
        }
    }

    protected void startCondition(SemanticModule module, String name, Attributes attrs) throws SAXException {
        this.state = 3;
        this.startConfiguration(name, attrs);
    }

    protected void endCondition(SemanticModule module, String localName) throws SAXException {
        Configuration config = this.endConfiguration();
        ConditionFactory factory = module.getConditionFactory(localName);
        try {
            try {
                Condition condition = factory.newCondition(config, this.rule.getAllDeclarations());
                this.rule.addCondition(condition);
            }
            catch (FactoryException e) {
                throw new SAXParseException("error constructing condition", this.getLocator(), (Exception)((Object)e));
            }
            Object var7_7 = null;
            this.state = 0;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.state = 0;
            throw throwable;
        }
    }

    protected void startConsequence(SemanticModule module, String name, Attributes attrs) throws SAXException {
        this.state = 5;
        this.startConfiguration(name, attrs);
    }

    protected void endConsequence(SemanticModule module, String localName) throws SAXException {
        Configuration config = this.endConfiguration();
        ConsequenceFactory factory = module.getConsequenceFactory(localName);
        try {
            try {
                Consequence consequence = factory.newConsequence(config, this.rule.getAllDeclarations());
                this.rule.setConsequence(consequence);
            }
            catch (FactoryException e) {
                throw new SAXParseException("error constructing consequence", this.getLocator(), (Exception)((Object)e));
            }
            Object var7_7 = null;
            this.state = 0;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.state = 0;
            throw throwable;
        }
    }

    protected void startConfiguration(String name, Attributes attrs) throws SAXException {
        this.characters = new StringBuffer();
        DefaultConfiguration config = new DefaultConfiguration(name);
        int numAttrs = attrs.getLength();
        int i = 0;
        while (i < numAttrs) {
            config.setAttribute(attrs.getLocalName(i), attrs.getValue(i));
            ++i;
        }
        if (this.configurationStack.isEmpty()) {
            this.configurationStack.addLast(config);
        } else {
            ((DefaultConfiguration)this.configurationStack.getLast()).addChild(config);
        }
    }

    public void characters(char[] chars, int start, int len) throws SAXException {
        if (this.characters != null) {
            this.characters.append(chars, start, len);
        }
    }

    protected Configuration endConfiguration() {
        DefaultConfiguration config = (DefaultConfiguration)this.configurationStack.removeLast();
        config.setText(this.characters.toString());
        this.characters = null;
        return config;
    }

    Starter lookupStarter(String uri, String name) {
        return (Starter)this.starters.get(uri + ">" + name);
    }

    void bindStarter(String uri, String name, Starter starter) {
        this.starters.put(uri + ">" + name, starter);
    }

    Ender lookupEnder(String uri, String name) {
        return (Ender)this.enders.get(uri + ">" + name);
    }

    void bindEnder(String uri, String name, Ender ender) {
        this.enders.put(uri + ">" + name, ender);
    }

    static abstract class Ender {
        Ender() {
        }

        abstract void end() throws SAXException;
    }

    static abstract class Starter {
        Starter() {
        }

        abstract void start(Attributes var1) throws SAXException;
    }
}

