/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.petstore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.examples.petstore.CartItem;

public class ShoppingCart {
    private List items;
    private double discount = 0.0;
    private Map states = new HashMap();
    private static String newline = System.getProperty("line.separator");

    public ShoppingCart() {
        this.items = new ArrayList();
    }

    public boolean getState(String state) {
        if (this.states.containsKey(state)) {
            return (Boolean)this.states.get(state);
        }
        return false;
    }

    public void setState(String state, boolean value) {
        this.states.put(state, new Boolean(value));
    }

    public void setDiscount(double discount) {
        this.discount = discount;
    }

    public double getDiscount() {
        return this.discount;
    }

    public void addItem(CartItem item) {
        this.items.add(item);
    }

    public List getItems() {
        return this.items;
    }

    public List getItems(String name) {
        ArrayList<CartItem> matching = new ArrayList<CartItem>();
        Iterator itemIter = this.getItems().iterator();
        CartItem eachItem = null;
        while (itemIter.hasNext()) {
            eachItem = (CartItem)itemIter.next();
            if (!eachItem.getName().equals(name)) continue;
            matching.add(eachItem);
        }
        return matching;
    }

    public double getGrossCost() {
        Iterator itemIter = this.getItems().iterator();
        CartItem eachItem = null;
        double cost = 0.0;
        while (itemIter.hasNext()) {
            eachItem = (CartItem)itemIter.next();
            cost += eachItem.getCost();
        }
        return cost;
    }

    public double getDiscountedCost() {
        double cost = this.getGrossCost();
        double discount = this.getDiscount();
        double discountedCost = cost * (1.0 - discount);
        return discountedCost;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ShoppingCart:" + newline);
        Iterator itemIter = this.getItems().iterator();
        while (itemIter.hasNext()) {
            buf.append("\t" + itemIter.next() + newline);
        }
        buf.append("gross total=" + this.getGrossCost() + newline);
        buf.append("discounted total=" + this.getDiscountedCost() + newline);
        return buf.toString();
    }
}

