/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.manners;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import org.drools.examples.manners.model.Context;
import org.drools.examples.manners.model.Guest;
import org.drools.examples.manners.model.LastSeat;
import org.drools.examples.manners.model.Seat;

public abstract class MannersBase {
    protected String ruleUri = "manners.java.drl";
    protected int numGuests = 16;
    protected int numSeats = 16;
    protected int minHobbies = 2;
    protected int maxHobbies = 3;

    protected MannersBase(String[] args) {
        if (args.length > 0) {
            this.ruleUri = args[0];
        }
        if (args.length > 1) {
            this.numSeats = this.numGuests = Integer.parseInt(args[1]);
        }
        if (args.length > 2) {
            this.numSeats = Integer.parseInt(args[2]);
        }
        if (args.length > 3) {
            this.minHobbies = Integer.parseInt(args[3]);
        }
        if (args.length > 4) {
            this.maxHobbies = Integer.parseInt(args[4]);
        }
    }

    protected void run() throws Exception {
        this.setUp();
        List inList = this.getInputObjects(this.generateData());
        System.out.println("Using drl: " + this.ruleUri);
        long start = System.currentTimeMillis();
        List outList = this.test(inList);
        System.out.println("Elapsed time: " + (System.currentTimeMillis() - start) + "ms");
        int actualGuests = MannersBase.validateResults(inList, outList);
        if (this.numGuests != actualGuests) {
            throw new RuntimeException("seated guests " + actualGuests + " didn't match expected " + this.numGuests);
        }
        this.tearDown();
    }

    protected abstract void setUp() throws Exception;

    protected abstract void tearDown() throws Exception;

    protected abstract List test(List var1) throws Exception;

    protected static int validateResults(List inList, List outList) {
        int seatCount = 0;
        Guest lastGuest = null;
        Iterator it = outList.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof Seat)) continue;
            Seat seat = (Seat)obj;
            if (lastGuest == null) {
                lastGuest = MannersBase.guest4Seat(inList, seat);
            }
            Guest guest = MannersBase.guest4Seat(inList, seat);
            boolean hobbyFound = false;
            for (int i = 0; !hobbyFound && i < lastGuest.getHobbies().size(); ++i) {
                String hobby = (String)lastGuest.getHobbies().get(i);
                if (!guest.getHobbies().contains(hobby)) continue;
                hobbyFound = true;
            }
            if (!hobbyFound) {
                throw new RuntimeException("seat: " + seat.getSeat() + " no common hobby " + lastGuest + " -> " + guest);
            }
            ++seatCount;
        }
        return seatCount;
    }

    private static Guest guest4Seat(List inList, Seat seat) {
        Iterator it = inList.iterator();
        while (it.hasNext()) {
            Guest guest;
            Object obj = it.next();
            if (!(obj instanceof Guest) || !(guest = (Guest)obj).getName().equals(seat.getName())) continue;
            return guest;
        }
        return null;
    }

    protected List getInputObjects(InputStream inputStream) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        HashMap<String, Guest> guests = new HashMap<String, Guest>();
        String line = null;
        while ((line = br.readLine()) != null) {
            if (line.trim().length() == 0 || line.trim().startsWith(";")) continue;
            StringTokenizer st = new StringTokenizer(line, "() ");
            String type = st.nextToken();
            if ("guest".equals(type)) {
                if (!"name".equals(st.nextToken())) {
                    throw new IOException("expected 'name' in: " + line);
                }
                String name = st.nextToken();
                if (!"sex".equals(st.nextToken())) {
                    throw new IOException("expected 'sex' in: " + line);
                }
                String sex = st.nextToken();
                if (!"hobby".equals(st.nextToken())) {
                    throw new IOException("expected 'hobby' in: " + line);
                }
                String hobby = st.nextToken();
                Guest guest = (Guest)guests.get(name);
                if (guest == null) {
                    guest = new Guest(name, sex.charAt(0));
                    guests.put(name, guest);
                    list.add(guest);
                }
                guest.addHobby(hobby);
            }
            if ("last_seat".equals(type)) {
                if (!"seat".equals(st.nextToken())) {
                    throw new IOException("expected 'seat' in: " + line);
                }
                list.add(new LastSeat(new Integer(st.nextToken())));
            }
            if (!"context".equals(type)) continue;
            if (!"state".equals(st.nextToken())) {
                throw new IOException("expected 'state' in: " + line);
            }
            list.add(new Context(st.nextToken()));
        }
        inputStream.close();
        return list;
    }

    protected InputStream generateData() {
        String LINE_SEPARATOR = System.getProperty("line.separator");
        StringWriter writer = new StringWriter();
        int maxMale = this.numGuests / 2;
        int maxFemale = this.numGuests / 2;
        int maleCount = 0;
        int femaleCount = 0;
        ArrayList<String> hobbyList = new ArrayList<String>();
        for (int i = 1; i <= this.maxHobbies; ++i) {
            hobbyList.add("h" + i);
        }
        Random rnd = new Random();
        for (int i = 1; i <= this.numGuests; ++i) {
            char sex;
            char c = sex = rnd.nextBoolean() ? (char)'m' : 'f';
            if (sex == 'm' && maleCount == maxMale) {
                sex = 'f';
            }
            if (sex == 'f' && femaleCount == maxFemale) {
                sex = 'm';
            }
            if (sex == 'm') {
                ++maleCount;
            }
            if (sex == 'f') {
                ++femaleCount;
            }
            ArrayList guestHobbies = new ArrayList(hobbyList);
            int numHobbies = this.minHobbies + rnd.nextInt(this.maxHobbies - this.minHobbies + 1);
            for (int j = 0; j < numHobbies; ++j) {
                int hobbyIndex = rnd.nextInt(guestHobbies.size());
                String hobby = (String)guestHobbies.get(hobbyIndex);
                writer.write("(guest (name n" + i + ") (sex " + sex + ") (hobby " + hobby + "))" + LINE_SEPARATOR);
                guestHobbies.remove(hobbyIndex);
            }
        }
        writer.write("(last_seat (seat " + this.numSeats + "))" + LINE_SEPARATOR);
        writer.write(LINE_SEPARATOR);
        writer.write("(context (state start))" + LINE_SEPARATOR);
        return new ByteArrayInputStream(writer.getBuffer().toString().getBytes());
    }
}

