/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.house;

import java.util.ArrayList;
import org.drools.examples.house.Room;
import org.drools.rule.Declaration;
import org.drools.rule.InvalidRuleException;
import org.drools.rule.Rule;
import org.drools.semantics.base.ClassObjectType;
import org.drools.smf.ConditionFactory;
import org.drools.smf.Configuration;
import org.drools.smf.FactoryException;
import org.drools.spi.Condition;
import org.drools.spi.ConditionException;
import org.drools.spi.ObjectType;
import org.drools.spi.RuleBaseContext;
import org.drools.spi.Tuple;

public class HouseConditionFactory
implements ConditionFactory {
    static /* synthetic */ Class class$org$drools$examples$house$Room;

    public Condition[] newCondition(Rule rule, RuleBaseContext context, Configuration config) throws FactoryException {
        Configuration childConfig = null;
        Configuration[] configurations = config.getChildren();
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (int i = 0; i < configurations.length; ++i) {
            childConfig = configurations[i];
            if (!childConfig.getName().equals("room")) continue;
            conditions.add(this.processRoom(rule, childConfig));
        }
        return conditions.toArray(new Condition[conditions.size()]);
    }

    private Condition processRoom(Rule rule, Configuration config) throws FactoryException {
        Configuration childConfig = null;
        final String roomName = config.getAttribute("name");
        final Declaration roomDeclaration = this.getDeclaration(rule, class$org$drools$examples$house$Room == null ? (class$org$drools$examples$house$Room = HouseConditionFactory.class$("org.drools.examples.house.Room")) : class$org$drools$examples$house$Room, roomName);
        Object condition = null;
        Configuration[] configurations = config.getChildren();
        for (int i = 0; i < configurations.length; ++i) {
            childConfig = configurations[i];
            if (!childConfig.getName().equals("temperature")) continue;
            final Declaration[] declarations = new Declaration[]{roomDeclaration};
            childConfig = childConfig.getChildren()[0];
            final int kelvin = this.getKelvin(childConfig.getAttribute("scale"), childConfig.getText());
            if (childConfig.getName().equals("less-than")) {
                condition = new Condition(){

                    public Declaration[] getRequiredTupleMembers() {
                        return declarations;
                    }

                    public boolean isAllowed(Tuple tuple) throws ConditionException {
                        Room room = (Room)tuple.get(roomDeclaration);
                        if (!roomName.equals(room.getName())) {
                            return false;
                        }
                        return room.getTemperature() < kelvin;
                    }
                };
                continue;
            }
            if (!childConfig.getName().equals("greater-than")) continue;
            condition = new Condition(){

                public Declaration[] getRequiredTupleMembers() {
                    return declarations;
                }

                public boolean isAllowed(Tuple tuple) throws ConditionException {
                    Room room = (Room)tuple.get(roomDeclaration);
                    if (!roomName.equals(room.getName())) {
                        return false;
                    }
                    return room.getTemperature() > kelvin;
                }
            };
        }
        return condition;
    }

    private Declaration getDeclaration(Rule rule, Class clazz, String identifier) throws FactoryException {
        Declaration declaration = rule.getParameterDeclaration(identifier);
        if (declaration == null) {
            ClassObjectType type = new ClassObjectType(clazz);
            try {
                declaration = rule.addParameterDeclaration(identifier, (ObjectType)type);
            }
            catch (InvalidRuleException e) {
                throw new FactoryException("xxx");
            }
        }
        return declaration;
    }

    private int getKelvin(String scale, String value) {
        int i = Integer.parseInt(value);
        if (scale.equals("F")) {
            i = (int)Math.round((double)(i - 32) / 1.8 + 273.0);
        }
        if (scale.equals("C")) {
            i += 273;
        }
        return i;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

