/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.benchmarks.waltz;

import java.util.HashSet;
import java.util.Set;
import org.drools.event.DefaultWorkingMemoryEventListener;
import org.drools.event.ObjectAssertedEvent;
import org.drools.event.ObjectModifiedEvent;
import org.drools.event.ObjectRetractedEvent;
import org.drools.examples.benchmarks.waltz.model.Edge;
import org.drools.examples.benchmarks.waltz.model.Junction;
import org.drools.examples.benchmarks.waltz.model.Line;

public class WaltzWMEL
extends DefaultWorkingMemoryEventListener {
    private static int lineCount;
    private static int joinedEdgeCount;
    private static int plottedEdgeCount;
    private static Set edgeSet;
    private static int maxJunctionBasePoint;
    private static int minJunctionBasePoint;

    public void objectAsserted(ObjectAssertedEvent event) {
        Object object = event.getObject();
        if (object instanceof Line) {
            ++lineCount;
        } else if (object instanceof Edge) {
            Edge edge = (Edge)object;
            if (edge.isJoined()) {
                ++joinedEdgeCount;
            }
            if (edge.isPlotted()) {
                ++plottedEdgeCount;
            }
            edgeSet.add(edge.getP1() + ":" + edge.getP2());
        } else if (object instanceof Junction) {
            Junction junction = (Junction)object;
            int basePoint = junction.getBasePoint();
            if (basePoint > maxJunctionBasePoint) {
                maxJunctionBasePoint = basePoint;
            }
            if (basePoint < minJunctionBasePoint) {
                minJunctionBasePoint = basePoint;
            }
        }
    }

    public void objectModified(ObjectModifiedEvent event) {
        Object oldObject = event.getOldObject();
        if (oldObject instanceof Line) {
            --lineCount;
        } else if (oldObject instanceof Edge) {
            Edge edge = (Edge)oldObject;
            if (edge.isJoined()) {
                --joinedEdgeCount;
            }
            if (edge.isPlotted()) {
                --plottedEdgeCount;
            }
        }
        Object newObject = event.getObject();
        if (newObject instanceof Line) {
            ++lineCount;
        } else if (newObject instanceof Edge) {
            Edge edge = (Edge)newObject;
            if (edge.isJoined()) {
                ++joinedEdgeCount;
            }
            if (edge.isPlotted()) {
                ++plottedEdgeCount;
            }
        }
    }

    public void objectRetracted(ObjectRetractedEvent event) {
        Object object = event.getOldObject();
        if (object instanceof Line) {
            --lineCount;
        } else if (object instanceof Edge) {
            Edge edge = (Edge)object;
            if (edge.isJoined()) {
                --joinedEdgeCount;
            }
            if (edge.isPlotted()) {
                --plottedEdgeCount;
            }
        }
    }

    public static boolean lineExists() {
        return lineCount != 0;
    }

    public static boolean edgeExists(int p1, int p2a, int p2b) {
        if (edgeSet.contains(p1 + ":" + p2a)) {
            return true;
        }
        return edgeSet.contains(p1 + ":" + p2b);
    }

    public static boolean joinedEdgeExists() {
        return joinedEdgeCount != 0;
    }

    public static boolean plottedEdgeExists() {
        return plottedEdgeCount != 0;
    }

    public static boolean greaterJunctionExists(int basePoint) {
        return basePoint != maxJunctionBasePoint;
    }

    public static boolean smallerJunctionExists(int basePoint) {
        return basePoint != minJunctionBasePoint;
    }

    static {
        edgeSet = new HashSet(512);
        maxJunctionBasePoint = -1;
        minJunctionBasePoint = Integer.MAX_VALUE;
    }
}

