/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.mcdiscordreserializer.renderer;

import dev.vankka.mcdiscordreserializer.minecraft.MinecraftSerializerOptions;
import dev.vankka.mcdiscordreserializer.renderer.MinecraftNodeRenderer;
import dev.vankka.mcdiscordreserializer.rules.DiscordMarkdownRules;
import dev.vankka.simpleast.core.TextStyle;
import dev.vankka.simpleast.core.node.Node;
import dev.vankka.simpleast.core.node.StyleNode;
import dev.vankka.simpleast.core.node.TextNode;
import java.util.ArrayList;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MinecraftRenderer
extends MinecraftNodeRenderer {
    @Override
    default public Component render(@NotNull Component component, @NotNull Node<Object> node, @NotNull MinecraftSerializerOptions<Component> serializerOptions, @NotNull Function<Node<Object>, Component> renderWithChildren) {
        if (node instanceof TextNode) {
            component = ((TextComponent)component).content(((TextNode)node).getContent());
        } else if (node instanceof StyleNode) {
            ArrayList styles = new ArrayList(((StyleNode)node).getStyles());
            for (TextStyle style : styles) {
                switch (style.getType()) {
                    case LINK: {
                        component = this.link(component, (String)style.getExtra().get("link"));
                        break;
                    }
                    case STRIKETHROUGH: {
                        component = this.strikethrough(component);
                        break;
                    }
                    case UNDERLINE: {
                        component = this.underline(component);
                        break;
                    }
                    case ITALICS: {
                        component = this.italics(component);
                        break;
                    }
                    case BOLD: {
                        component = this.bold(component);
                        break;
                    }
                    case CODE_STRING: {
                        component = this.codeString(component);
                        ((StyleNode)node).getStyles().remove(style);
                        break;
                    }
                    case CODE_BLOCK: {
                        component = this.codeBlock(component);
                        ((StyleNode)node).getStyles().remove(style);
                        break;
                    }
                    case QUOTE: {
                        TextComponent content = Component.empty();
                        for (Node objectNode : serializerOptions.getParser().parse((CharSequence)style.getExtra().get("content"), (Object)new DiscordMarkdownRules.QuoteState(true), serializerOptions.getRules(), serializerOptions.isDebuggingEnabled())) {
                            content = (TextComponent)content.append(renderWithChildren.apply((Node<Object>)objectNode));
                        }
                        component = this.appendQuote(component, (Component)content);
                        break;
                    }
                    case SPOILER: {
                        TextComponent content = Component.empty();
                        for (Node objectNode : serializerOptions.getParser().parse((CharSequence)style.getExtra().get("content"), null, serializerOptions.getRules(), serializerOptions.isDebuggingEnabled())) {
                            content = (TextComponent)content.append(renderWithChildren.apply((Node<Object>)objectNode));
                        }
                        component = this.appendSpoiler(component, (Component)content);
                        break;
                    }
                    case MENTION_EMOJI: {
                        component = this.appendEmoteMention(component, (String)style.getExtra().get("name"), (String)style.getExtra().get("id"));
                        break;
                    }
                    case MENTION_CHANNEL: {
                        component = this.appendChannelMention(component, (String)style.getExtra().get("id"));
                        break;
                    }
                    case MENTION_USER: {
                        component = this.appendUserMention(component, (String)style.getExtra().get("id"));
                        break;
                    }
                    case MENTION_ROLE: {
                        component = this.appendRoleMention(component, (String)style.getExtra().get("id"));
                        break;
                    }
                }
                if (component != null) continue;
                break;
            }
        }
        return component;
    }

    public Component link(@NotNull Component var1, String var2);

    @Nullable
    public Component strikethrough(@NotNull Component var1);

    @Nullable
    public Component underline(@NotNull Component var1);

    @Nullable
    public Component italics(@NotNull Component var1);

    @Nullable
    public Component bold(@NotNull Component var1);

    @Nullable
    public Component codeString(@NotNull Component var1);

    @Nullable
    public Component codeBlock(@NotNull Component var1);

    @Nullable
    public Component appendSpoiler(@NotNull Component var1, @NotNull Component var2);

    @Nullable
    public Component appendQuote(@NotNull Component var1, @NotNull Component var2);

    @Nullable
    public Component appendEmoteMention(@NotNull Component var1, @NotNull String var2, @NotNull String var3);

    @Nullable
    public Component appendChannelMention(@NotNull Component var1, @NotNull String var2);

    @Nullable
    public Component appendUserMention(@NotNull Component var1, @NotNull String var2);

    @Nullable
    public Component appendRoleMention(@NotNull Component var1, @NotNull String var2);
}

