/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.mcdiscordreserializer.minecraft;

import dev.vankka.mcdiscordreserializer.minecraft.MinecraftSerializerOptions;
import dev.vankka.mcdiscordreserializer.renderer.NodeRenderer;
import dev.vankka.mcdiscordreserializer.renderer.implementation.DefaultDiscordEscapingRenderer;
import dev.vankka.mcdiscordreserializer.renderer.implementation.DefaultMinecraftRenderer;
import dev.vankka.simpleast.core.node.Node;
import dev.vankka.simpleast.core.node.TextNode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public class MinecraftSerializer {
    @NotNull
    public static final MinecraftSerializer INSTANCE = new MinecraftSerializer(){

        @Override
        public void setDefaultOptions(@NotNull MinecraftSerializerOptions<Component> defaultOptions) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }

        @Override
        @Deprecated
        public void setMarkdownDefaultOptions(@NotNull MinecraftSerializerOptions<String> markdownDefaultOptions) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }
    };
    @NotNull
    private MinecraftSerializerOptions<Component> defaultOptions;
    @Deprecated
    private MinecraftSerializerOptions<String> markdownDefaultOptions;

    public MinecraftSerializer() {
        this(MinecraftSerializerOptions.defaults());
    }

    public MinecraftSerializer(@NotNull MinecraftSerializerOptions<Component> defaultOptions) {
        this.defaultOptions = defaultOptions;
        this.markdownDefaultOptions = MinecraftSerializerOptions.escapeDefaults();
    }

    @Deprecated
    public MinecraftSerializer(@NotNull MinecraftSerializerOptions<Component> defaultOptions, @NotNull MinecraftSerializerOptions<String> markdownDefaultOptions) {
        this.defaultOptions = defaultOptions;
        this.markdownDefaultOptions = markdownDefaultOptions;
    }

    @NotNull
    public Component serialize(@NotNull String discordMessage) {
        MinecraftSerializerOptions<Component> options = this.getDefaultOptions();
        return this.serialize(discordMessage, options);
    }

    @NotNull
    public Component serialize(@NotNull String discordMessage, @NotNull MinecraftSerializerOptions<Component> serializerOptions) {
        ArrayList<Component> components = new ArrayList<Component>();
        List nodes = serializerOptions.getParser().parse((CharSequence)discordMessage, null, serializerOptions.getRules(), serializerOptions.isDebuggingEnabled());
        nodes = this.flattenTextNodes(nodes);
        for (Node node : nodes) {
            components.add(this.addChild((Node<Object>)node, (Component)Component.empty(), serializerOptions));
        }
        return Component.empty().children(components);
    }

    @Deprecated
    public String escapeMarkdown(@NotNull String discordMessage) {
        return this.escapeMarkdown(discordMessage, this.getMarkdownDefaultOptions());
    }

    @Deprecated
    public String escapeMarkdown(@NotNull String discordMessage, @NotNull MinecraftSerializerOptions<String> serializerOptions) {
        String output = "";
        List nodes = serializerOptions.getParser().parse((CharSequence)discordMessage, null, serializerOptions.getRules(), serializerOptions.isDebuggingEnabled());
        nodes = this.flattenTextNodes(nodes);
        for (Node node : nodes) {
            output = this.addChild((Node<Object>)node, output, serializerOptions);
        }
        return output;
    }

    private Component addChild(Node<Object> node, Component styleNode, MinecraftSerializerOptions<Component> serializerOptions) {
        Component newOutput;
        Component component = Component.empty().mergeStyle(styleNode);
        Function<Node, Component> renderWithChildren = otherNode -> this.addChild((Node<Object>)otherNode, component, serializerOptions);
        Component output = null;
        Object render = null;
        for (NodeRenderer<Component> renderer : serializerOptions.getRenderers()) {
            Component currentOutput = renderer.render(component, node, serializerOptions, renderWithChildren);
            if (currentOutput == null) continue;
            output = currentOutput;
            render = renderer;
            break;
        }
        if (output == null && (output = (render = DefaultMinecraftRenderer.INSTANCE).render(component, node, serializerOptions, renderWithChildren)) == null) {
            throw new IllegalStateException("DefaultMinecraftRenderer returned a null component");
        }
        List children = node.getChildren();
        if (children != null) {
            for (Node child : children) {
                output = output.append(this.addChild((Node<Object>)child, output, serializerOptions));
            }
        }
        if ((newOutput = render.renderAfterChildren(output, node, serializerOptions, renderWithChildren)) != null) {
            output = newOutput;
        }
        return output;
    }

    private String addChild(Node<Object> node, String input, MinecraftSerializerOptions<String> serializerOptions) {
        String newOutput;
        List children;
        Function<Node, String> renderWithChildren = otherNode -> this.addChild((Node<Object>)otherNode, input, serializerOptions);
        String output = null;
        Object render = null;
        for (NodeRenderer<String> renderer : serializerOptions.getRenderers()) {
            output = renderer.render(output, node, serializerOptions, renderWithChildren);
            if (output == null) continue;
            render = renderer;
            break;
        }
        if (output == null) {
            render = DefaultDiscordEscapingRenderer.INSTANCE;
            output = render.render(input, node, serializerOptions, renderWithChildren);
        }
        if ((children = node.getChildren()) != null) {
            for (Node child : children) {
                output = this.addChild((Node<Object>)child, output, serializerOptions);
            }
        }
        if ((newOutput = render.renderAfterChildren(output, node, serializerOptions, renderWithChildren)) != null) {
            output = newOutput;
        }
        return output;
    }

    private <R, T extends Node<R>> List<T> flattenTextNodes(List<T> nodes) {
        ArrayList<Object> newNodes = new ArrayList<Object>();
        TextNode previousNode = null;
        for (Node node : nodes) {
            List children = node.getChildren();
            if (!children.isEmpty()) {
                if (previousNode != null) {
                    newNodes.add(previousNode);
                    previousNode = null;
                }
                List<T> childNodes = this.flattenTextNodes(children);
                node.getChildren().clear();
                node.getChildren().addAll(childNodes);
                newNodes.add(node);
                continue;
            }
            if (!(node instanceof TextNode)) {
                if (previousNode != null) {
                    newNodes.add(previousNode);
                    previousNode = null;
                }
                newNodes.add(node);
                continue;
            }
            if (previousNode == null) {
                previousNode = (TextNode)node;
                continue;
            }
            previousNode = new TextNode(previousNode.getContent() + ((TextNode)node).getContent());
        }
        if (previousNode != null) {
            newNodes.add(previousNode);
        }
        return newNodes;
    }

    @NotNull
    public MinecraftSerializerOptions<Component> getDefaultOptions() {
        return this.defaultOptions;
    }

    public void setDefaultOptions(@NotNull MinecraftSerializerOptions<Component> defaultOptions) {
        if (defaultOptions == null) {
            throw new NullPointerException("defaultOptions is marked non-null but is null");
        }
        this.defaultOptions = defaultOptions;
    }

    @Deprecated
    public MinecraftSerializerOptions<String> getMarkdownDefaultOptions() {
        return this.markdownDefaultOptions;
    }

    @Deprecated
    public void setMarkdownDefaultOptions(MinecraftSerializerOptions<String> markdownDefaultOptions) {
        this.markdownDefaultOptions = markdownDefaultOptions;
    }
}

