/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.mcdiscordreserializer.discord;

import java.util.function.Function;
import lombok.NonNull;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.TranslatableComponent;

public final class DiscordSerializerOptions {
    private final boolean embedLinks;
    private final boolean escapeMarkdown;
    @NonNull
    private final Function<KeybindComponent, String> keybindProvider;
    @NonNull
    private final Function<TranslatableComponent, String> translationProvider;

    public static DiscordSerializerOptions defaults() {
        return new DiscordSerializerOptions(false, true, KeybindComponent::keybind, TranslatableComponent::key);
    }

    public DiscordSerializerOptions(boolean embedLinks, boolean escapeMarkdown, @NonNull Function<KeybindComponent, String> keybindProvider, @NonNull Function<TranslatableComponent, String> translationProvider) {
        if (keybindProvider == null) {
            throw new NullPointerException("keybindProvider is marked non-null but is null");
        }
        if (translationProvider == null) {
            throw new NullPointerException("translationProvider is marked non-null but is null");
        }
        this.embedLinks = embedLinks;
        this.escapeMarkdown = escapeMarkdown;
        this.keybindProvider = keybindProvider;
        this.translationProvider = translationProvider;
    }

    public String toString() {
        return "DiscordSerializerOptions(embedLinks=" + this.isEmbedLinks() + ", escapeMarkdown=" + this.isEscapeMarkdown() + ", keybindProvider=" + this.getKeybindProvider() + ", translationProvider=" + this.getTranslationProvider() + ")";
    }

    public boolean isEmbedLinks() {
        return this.embedLinks;
    }

    public boolean isEscapeMarkdown() {
        return this.escapeMarkdown;
    }

    @NonNull
    public Function<KeybindComponent, String> getKeybindProvider() {
        return this.keybindProvider;
    }

    @NonNull
    public Function<TranslatableComponent, String> getTranslationProvider() {
        return this.translationProvider;
    }

    public DiscordSerializerOptions withEmbedLinks(boolean embedLinks) {
        return this.embedLinks == embedLinks ? this : new DiscordSerializerOptions(embedLinks, this.escapeMarkdown, this.keybindProvider, this.translationProvider);
    }

    public DiscordSerializerOptions withEscapeMarkdown(boolean escapeMarkdown) {
        return this.escapeMarkdown == escapeMarkdown ? this : new DiscordSerializerOptions(this.embedLinks, escapeMarkdown, this.keybindProvider, this.translationProvider);
    }

    public DiscordSerializerOptions withKeybindProvider(@NonNull Function<KeybindComponent, String> keybindProvider) {
        if (keybindProvider == null) {
            throw new NullPointerException("keybindProvider is marked non-null but is null");
        }
        return this.keybindProvider == keybindProvider ? this : new DiscordSerializerOptions(this.embedLinks, this.escapeMarkdown, keybindProvider, this.translationProvider);
    }

    public DiscordSerializerOptions withTranslationProvider(@NonNull Function<TranslatableComponent, String> translationProvider) {
        if (translationProvider == null) {
            throw new NullPointerException("translationProvider is marked non-null but is null");
        }
        return this.translationProvider == translationProvider ? this : new DiscordSerializerOptions(this.embedLinks, this.escapeMarkdown, this.keybindProvider, translationProvider);
    }
}

