/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.mcdiscordreserializer.discord;

import dev.vankka.mcdiscordreserializer.discord.DiscordSerializerOptions;
import dev.vankka.mcdiscordreserializer.text.Text;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.TextDecoration;

public class DiscordSerializer {
    public static final DiscordSerializer INSTANCE = new DiscordSerializer(){

        @Override
        public void setDefaultOptions(DiscordSerializerOptions defaultOptions) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }

        @Override
        @Deprecated
        public void setKeybindProvider(Function<KeybindComponent, String> provider) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }

        @Override
        @Deprecated
        public void setTranslationProvider(Function<TranslatableComponent, String> provider) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }
    };
    private DiscordSerializerOptions defaultOptions;
    private Function<KeybindComponent, String> keybindProvider;
    private Function<TranslatableComponent, String> translationProvider;

    public DiscordSerializer() {
        this(DiscordSerializerOptions.defaults());
    }

    public DiscordSerializer(@NonNull DiscordSerializerOptions defaultOptions) {
        if (defaultOptions == null) {
            throw new NullPointerException("defaultOptions is marked non-null but is null");
        }
        this.defaultOptions = defaultOptions;
    }

    @Deprecated
    public DiscordSerializer(Function<KeybindComponent, String> keybindProvider, Function<TranslatableComponent, String> translationProvider) {
        this.defaultOptions = DiscordSerializerOptions.defaults();
        this.keybindProvider = keybindProvider;
        this.translationProvider = translationProvider;
    }

    @Deprecated
    public Function<KeybindComponent, String> getKeybindProvider() {
        return this.keybindProvider;
    }

    @Deprecated
    public void setKeybindProvider(Function<KeybindComponent, String> provider) {
        this.keybindProvider = provider;
    }

    @Deprecated
    public Function<TranslatableComponent, String> getTranslationProvider() {
        return this.translationProvider;
    }

    @Deprecated
    public void setTranslationProvider(Function<TranslatableComponent, String> provider) {
        this.translationProvider = provider;
    }

    public String serialize(@NonNull Component component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        DiscordSerializerOptions options = this.getDefaultOptions();
        if (this.keybindProvider != null) {
            options = options.withKeybindProvider(this.keybindProvider);
        }
        if (this.translationProvider != null) {
            options = options.withTranslationProvider(this.translationProvider);
        }
        return this.serialize(component, options);
    }

    @Deprecated
    public String serialize(@NonNull Component component, boolean embedLinks) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        return this.serialize(component, this.defaultOptions.withEmbedLinks(embedLinks));
    }

    public String serialize(@NonNull Component component, @NonNull DiscordSerializerOptions serializerOptions) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (serializerOptions == null) {
            throw new NullPointerException("serializerOptions is marked non-null but is null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        LinkedList<Text> texts = this.getTexts(new LinkedList<Text>(), component, new Text(), serializerOptions);
        for (Text text : texts) {
            String content = text.getContent();
            if (content.isEmpty()) continue;
            if (text.isBold()) {
                stringBuilder.append("**");
            }
            if (text.isStrikethrough()) {
                stringBuilder.append("~~");
            }
            if (text.isItalic()) {
                stringBuilder.append("_");
            }
            if (text.isUnderline()) {
                stringBuilder.append("__");
            }
            if (serializerOptions.isEscapeMarkdown()) {
                content = content.replace("(?<!\\\\)(?:\\\\\\\\)*\\*", "\\*").replace("(?<!\\\\)(?:\\\\\\\\)*~", "\\~").replace("(?<!\\\\)(?:\\\\\\\\)*_", "\\_").replace("(?<!\\\\)(?:\\\\\\\\)*`", "\\`").replace("(?<!\\\\)(?:\\\\\\\\)*\\|", "\\|");
            }
            stringBuilder.append(content);
            if (text.isUnderline()) {
                stringBuilder.append("__");
            }
            if (text.isItalic()) {
                stringBuilder.append("_");
            }
            if (text.isStrikethrough()) {
                stringBuilder.append("~~");
            }
            if (text.isBold()) {
                stringBuilder.append("**");
            }
            stringBuilder.append("\u200b");
        }
        int length = stringBuilder.length();
        return length < 1 ? "" : stringBuilder.substring(0, length - 1);
    }

    private LinkedList<Text> getTexts(@NonNull List<Text> input, @NonNull Component component, @NonNull Text text, @NonNull DiscordSerializerOptions serializerOptions) {
        Text previous;
        TextDecoration.State strikethrough;
        TextDecoration.State underline;
        TextDecoration.State italic;
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (serializerOptions == null) {
            throw new NullPointerException("serializerOptions is marked non-null but is null");
        }
        LinkedList<Text> output = new LinkedList<Text>(input);
        String content = component instanceof KeybindComponent ? this.keybindProvider.apply((KeybindComponent)component) : (component instanceof ScoreComponent ? ((ScoreComponent)component).value() : (component instanceof SelectorComponent ? ((SelectorComponent)component).pattern() : (component instanceof TextComponent ? ((TextComponent)component).content() : (component instanceof TranslatableComponent ? this.translationProvider.apply((TranslatableComponent)component) : ""))));
        ClickEvent clickEvent = component.clickEvent();
        if (serializerOptions.isEmbedLinks() && clickEvent != null && clickEvent.action() == ClickEvent.Action.OPEN_URL) {
            text.setContent("[" + content + "](" + clickEvent.value() + ")");
        } else {
            text.setContent(content);
        }
        TextDecoration.State bold = component.decoration(TextDecoration.BOLD);
        if (bold != TextDecoration.State.NOT_SET) {
            text.setBold(bold == TextDecoration.State.TRUE);
        }
        if ((italic = component.decoration(TextDecoration.ITALIC)) != TextDecoration.State.NOT_SET) {
            text.setItalic(italic == TextDecoration.State.TRUE);
        }
        if ((underline = component.decoration(TextDecoration.UNDERLINED)) != TextDecoration.State.NOT_SET) {
            text.setUnderline(underline == TextDecoration.State.TRUE);
        }
        if ((strikethrough = component.decoration(TextDecoration.STRIKETHROUGH)) != TextDecoration.State.NOT_SET) {
            text.setStrikethrough(strikethrough == TextDecoration.State.TRUE);
        }
        if (!output.isEmpty() && text.formattingMatches(previous = output.getLast())) {
            output.removeLast();
            text.setContent(previous.getContent() + text.getContent());
        }
        output.add(text);
        for (Component child : component.children()) {
            Text next = text.clone();
            next.setContent("");
            output = this.getTexts(output, child, next, serializerOptions);
        }
        return output;
    }

    public DiscordSerializerOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    public void setDefaultOptions(DiscordSerializerOptions defaultOptions) {
        this.defaultOptions = defaultOptions;
    }
}

