/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.mcdiscordreserializer.minecraft;

import dev.vankka.mcdiscordreserializer.minecraft.MinecraftSerializerOptions;
import dev.vankka.mcdiscordreserializer.renderer.NodeRenderer;
import dev.vankka.mcdiscordreserializer.renderer.implementation.DefaultDiscordEscapingRenderer;
import dev.vankka.mcdiscordreserializer.renderer.implementation.DefaultMinecraftRenderer;
import dev.vankka.simpleast.core.node.Node;
import dev.vankka.simpleast.core.node.TextNode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import lombok.NonNull;
import net.kyori.adventure.text.Component;

public class MinecraftSerializer {
    public static final MinecraftSerializer INSTANCE = new MinecraftSerializer(){

        @Override
        public void setDefaultOptions(MinecraftSerializerOptions<Component> defaultOptions) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }

        @Override
        public void setMarkdownDefaultOptions(MinecraftSerializerOptions<String> markdownDefaultOptions) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }
    };
    private MinecraftSerializerOptions<Component> defaultOptions;
    private MinecraftSerializerOptions<String> markdownDefaultOptions;

    public MinecraftSerializer() {
        this(MinecraftSerializerOptions.defaults(), MinecraftSerializerOptions.escapeDefaults());
    }

    public MinecraftSerializer(@NonNull MinecraftSerializerOptions<Component> defaultOptions, @NonNull MinecraftSerializerOptions<String> markdownDefaultOptions) {
        if (defaultOptions == null) {
            throw new NullPointerException("defaultOptions is marked non-null but is null");
        }
        if (markdownDefaultOptions == null) {
            throw new NullPointerException("markdownDefaultOptions is marked non-null but is null");
        }
        this.defaultOptions = defaultOptions;
        this.markdownDefaultOptions = markdownDefaultOptions;
    }

    public Component serialize(@NonNull String discordMessage) {
        if (discordMessage == null) {
            throw new NullPointerException("discordMessage is marked non-null but is null");
        }
        MinecraftSerializerOptions<Component> options = this.getDefaultOptions();
        return this.serialize(discordMessage, options);
    }

    public Component serialize(@NonNull String discordMessage, @NonNull MinecraftSerializerOptions<Component> serializerOptions) {
        if (discordMessage == null) {
            throw new NullPointerException("discordMessage is marked non-null but is null");
        }
        if (serializerOptions == null) {
            throw new NullPointerException("serializerOptions is marked non-null but is null");
        }
        ArrayList<Component> components = new ArrayList<Component>();
        List nodes = serializerOptions.getParser().parse((CharSequence)discordMessage, null, serializerOptions.getRules(), serializerOptions.isDebuggingEnabled());
        nodes = this.flattenTextNodes(nodes);
        for (Node node : nodes) {
            components.add(this.addChild((Node<Object>)node, (Component)Component.empty(), serializerOptions));
        }
        return Component.empty().children(components);
    }

    public String escapeMarkdown(@NonNull String discordMessage) {
        if (discordMessage == null) {
            throw new NullPointerException("discordMessage is marked non-null but is null");
        }
        return this.escapeMarkdown(discordMessage, this.getMarkdownDefaultOptions());
    }

    public String escapeMarkdown(@NonNull String discordMessage, @NonNull MinecraftSerializerOptions<String> serializerOptions) {
        if (discordMessage == null) {
            throw new NullPointerException("discordMessage is marked non-null but is null");
        }
        if (serializerOptions == null) {
            throw new NullPointerException("serializerOptions is marked non-null but is null");
        }
        String output = "";
        List nodes = serializerOptions.getParser().parse((CharSequence)discordMessage, null, serializerOptions.getRules(), serializerOptions.isDebuggingEnabled());
        nodes = this.flattenTextNodes(nodes);
        for (Node node : nodes) {
            output = this.addChild((Node<Object>)node, output, serializerOptions);
        }
        return output;
    }

    private Component addChild(Node<Object> node, Component styleNode, MinecraftSerializerOptions<Component> serializerOptions) {
        Component newOutput;
        List children;
        Component component = Component.empty().mergeStyle(styleNode);
        Function<Node, Component> renderWithChildren = otherNode -> this.addChild((Node<Object>)otherNode, component, serializerOptions);
        Component output = null;
        Object render = null;
        for (NodeRenderer<Component> renderer : serializerOptions.getRenderers()) {
            output = renderer.render(component, node, serializerOptions, renderWithChildren);
            if (output == null) continue;
            render = renderer;
            break;
        }
        if (output == null) {
            render = DefaultMinecraftRenderer.INSTANCE;
            output = render.render(component, node, serializerOptions, renderWithChildren);
        }
        if ((children = node.getChildren()) != null) {
            for (Node child : children) {
                output = output.append(this.addChild((Node<Object>)child, output, serializerOptions));
            }
        }
        if ((newOutput = render.renderAfterChildren(output, node, serializerOptions, renderWithChildren)) != null) {
            output = newOutput;
        }
        return output;
    }

    private String addChild(Node<Object> node, String input, MinecraftSerializerOptions<String> serializerOptions) {
        String newOutput;
        List children;
        Function<Node, String> renderWithChildren = otherNode -> this.addChild((Node<Object>)otherNode, input, serializerOptions);
        String output = null;
        Object render = null;
        for (NodeRenderer<String> renderer : serializerOptions.getRenderers()) {
            output = renderer.render(output, node, serializerOptions, renderWithChildren);
            if (output == null) continue;
            render = renderer;
            break;
        }
        if (output == null) {
            render = DefaultDiscordEscapingRenderer.INSTANCE;
            output = render.render(input, node, serializerOptions, renderWithChildren);
        }
        if ((children = node.getChildren()) != null) {
            for (Node child : children) {
                output = this.addChild((Node<Object>)child, output, serializerOptions);
            }
        }
        if ((newOutput = render.renderAfterChildren(output, node, serializerOptions, renderWithChildren)) != null) {
            output = newOutput;
        }
        return output;
    }

    private <R, T extends Node<R>> List<T> flattenTextNodes(List<T> nodes) {
        ArrayList<Object> newNodes = new ArrayList<Object>();
        TextNode previousNode = null;
        for (Node node : nodes) {
            List children = node.getChildren();
            if (!children.isEmpty()) {
                if (previousNode != null) {
                    newNodes.add(previousNode);
                    previousNode = null;
                }
                List<T> childNodes = this.flattenTextNodes(children);
                node.getChildren().clear();
                node.getChildren().addAll(childNodes);
                newNodes.add(node);
                continue;
            }
            if (!(node instanceof TextNode)) {
                if (previousNode != null) {
                    newNodes.add(previousNode);
                    previousNode = null;
                }
                newNodes.add(node);
                continue;
            }
            if (previousNode == null) {
                previousNode = (TextNode)node;
                continue;
            }
            previousNode = new TextNode(previousNode.getContent() + ((TextNode)node).getContent());
        }
        if (previousNode != null) {
            newNodes.add(previousNode);
        }
        return newNodes;
    }

    public MinecraftSerializerOptions<Component> getDefaultOptions() {
        return this.defaultOptions;
    }

    public void setDefaultOptions(MinecraftSerializerOptions<Component> defaultOptions) {
        this.defaultOptions = defaultOptions;
    }

    public MinecraftSerializerOptions<String> getMarkdownDefaultOptions() {
        return this.markdownDefaultOptions;
    }

    public void setMarkdownDefaultOptions(MinecraftSerializerOptions<String> markdownDefaultOptions) {
        this.markdownDefaultOptions = markdownDefaultOptions;
    }
}

