/*
 * Decompiled with CFR 0.152.
 */
package dev.tuxjsql.hikaricp.cp;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import dev.tuxjsql.core.TuxJSQL;
import dev.tuxjsql.core.connection.ConnectionProvider;
import dev.tuxjsql.core.connection.ConnectionSettings;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public class HikariConnectionProvider
implements ConnectionProvider {
    private HikariDataSource dataSource;

    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            TuxJSQL.getLogger().error("Unable to get connection", (Throwable)e);
            return null;
        }
    }

    public void close() {
        this.dataSource.close();
    }

    public void returnConnection(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException e) {
            TuxJSQL.getLogger().error("Unable to return connection", (Throwable)e);
        }
    }

    public boolean isConnected() {
        return !this.dataSource.isClosed();
    }

    public String name() {
        return "hikaricp-cp";
    }

    public void setup(ConnectionSettings settings, Properties userSettings) throws Exception {
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(settings.getDriver());
        config.setJdbcUrl(settings.getUrl());
        config.setUsername(userSettings.getProperty("user", ""));
        config.setPassword(userSettings.getProperty("password", ""));
        config.setIdleTimeout(Long.parseLong(userSettings.getProperty("idle.timeout", "30000")));
        config.setLeakDetectionThreshold(Long.parseLong(userSettings.getProperty("leak.detection", "30000")));
        config.setMaximumPoolSize(Integer.parseInt(userSettings.getProperty("pool.size", "5")));
        config.setPoolName(userSettings.getProperty(userSettings.getProperty("pool.name", "TuxJSQL")));
        this.dataSource = new HikariDataSource(config);
    }

    public boolean isClosed() {
        return this.dataSource.isClosed();
    }
}

