/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.demo.util;

import dev.onvoid.webrtc.demo.util.ListChangeListener;
import dev.onvoid.webrtc.demo.util.ObservableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;

public class ObservableArrayList<T>
extends ArrayList<T>
implements ObservableList<T> {
    private static final long serialVersionUID = -2986628478190499263L;
    private final transient List<ListChangeListener<ObservableList<T>>> listeners = new ArrayList<ListChangeListener<ObservableList<T>>>();

    @Override
    public boolean add(T element) {
        super.add(element);
        this.notifyInserted(this.size() - 1, 1);
        return true;
    }

    @Override
    public void add(int index, T element) {
        super.add(index, element);
        this.notifyInserted(index, 1);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        int oldSize = this.size();
        boolean added = super.addAll(collection);
        if (added) {
            this.notifyInserted(oldSize, this.size() - oldSize);
        }
        return added;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> collection) {
        boolean added = super.addAll(index, collection);
        if (added) {
            this.notifyInserted(index, collection.size());
        }
        return added;
    }

    @Override
    public void clear() {
        int oldSize = this.size();
        super.clear();
        if (oldSize != 0) {
            this.notifyRemoved(0, oldSize);
        }
    }

    @Override
    public T remove(int index) {
        Object element = super.remove(index);
        this.notifyRemoved(index, 1);
        return (T)element;
    }

    @Override
    public boolean remove(Object object) {
        int index = this.indexOf(object);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        boolean removed = super.removeIf(filter);
        if (removed) {
            this.notifyRemoved(0, 1);
        }
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        int oldSize = this.size();
        boolean changed = super.retainAll(c);
        if (changed) {
            this.notifyChanged(0, oldSize);
        }
        return changed;
    }

    @Override
    public T set(int index, T object) {
        T element = super.set(index, object);
        this.notifyChanged(index, 1);
        return element;
    }

    @Override
    public void addListener(ListChangeListener<ObservableList<T>> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ListChangeListener<ObservableList<T>> listener) {
        this.listeners.remove(listener);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        super.removeRange(fromIndex, toIndex);
        this.notifyRemoved(fromIndex, toIndex - fromIndex);
    }

    private void notifyInserted(int start, int count) {
        for (ListChangeListener<ObservableList<ObservableArrayList>> listChangeListener : this.listeners) {
            listChangeListener.listItemsInserted(this, start, count);
        }
    }

    private void notifyRemoved(int start, int count) {
        for (ListChangeListener<ObservableList<ObservableArrayList>> listChangeListener : this.listeners) {
            listChangeListener.listItemsRemoved(this, start, count);
        }
    }

    private void notifyChanged(int start, int count) {
        for (ListChangeListener<ObservableList<ObservableArrayList>> listChangeListener : this.listeners) {
            listChangeListener.listItemsChanged(this, start, count);
        }
    }
}

