/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.demo.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class AggregateBundle
extends ResourceBundle {
    private final Map<String, Object> contents = new HashMap<String, Object>();
    private Locale locale;

    public AggregateBundle(Locale locale, String ... bundleNames) throws IOException {
        this.locale = locale;
        this.load(bundleNames);
    }

    public void load(String ... bundleNames) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (String name : bundleNames) {
            if (name.isEmpty()) continue;
            String resourcePath = name.replaceAll("\\.", "/");
            File bundlePath = new File(resourcePath);
            String parentPath = bundlePath.getParent().replace("\\", "/");
            String baseName = bundlePath.getName();
            this.scanForBundles(cl, parentPath, baseName);
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public boolean containsKey(String key) {
        return this.contents.containsKey(key);
    }

    @Override
    public Enumeration<String> getKeys() {
        return new IteratorEnumeration<String>(this.contents.keySet().iterator());
    }

    @Override
    protected Object handleGetObject(String key) {
        return this.contents.get(key);
    }

    private void scanForBundles(ClassLoader cl, String path, String baseName) throws IOException {
        ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_DEFAULT);
        List<Locale> candidateLocales = control.getCandidateLocales(baseName, this.locale);
        Enumeration<URL> names = cl.getResources(path);
        while (names.hasMoreElements()) {
            File jarFile;
            Locale tagLocale;
            URL url = names.nextElement();
            String protocol = url.getProtocol();
            if (protocol.equals("file")) {
                String[] list;
                File parent = new File(url.getFile());
                if (!parent.isDirectory() || Objects.isNull(list = parent.list())) continue;
                for (String name : list) {
                    File file = new File(name);
                    if (file.isDirectory() || !name.startsWith(baseName) || !name.endsWith(".properties") || !candidateLocales.contains(tagLocale = AggregateBundle.extractLocale(name, baseName))) continue;
                    File resource = new File(url.getFile() + "/" + name);
                    this.loadBundle(resource.toURI().toURL().openStream());
                }
                continue;
            }
            if (!protocol.equals("jar")) continue;
            String searchPath = path + "/" + baseName;
            String urlPath = url.getPath();
            urlPath = urlPath.substring(0, urlPath.indexOf("!"));
            try {
                jarFile = Paths.get(new URL(urlPath).toURI()).toFile();
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
            JarFile jar = new JarFile(jarFile);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (entry.isDirectory() || !name.startsWith(searchPath) || !candidateLocales.contains(tagLocale = AggregateBundle.extractLocale(name, baseName))) continue;
                this.loadBundle(jar.getInputStream(entry));
            }
            jar.close();
        }
    }

    private void loadBundle(InputStream stream) throws IOException {
        if (Objects.isNull(stream)) {
            return;
        }
        try (InputStream inputStream = stream;){
            Properties props = new Properties();
            props.load(stream);
            Enumeration<Object> keys = props.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (this.contents.containsKey(key)) continue;
                this.contents.put(key, props.getProperty(key));
            }
        }
    }

    private static Locale extractLocale(String path, String baseName) {
        String tag = AggregateBundle.stripExtension(path);
        tag = tag.substring(tag.indexOf(baseName) + baseName.length(), tag.length());
        if ((tag = tag.replace("_", "-")).startsWith("-")) {
            tag = tag.substring(1);
        }
        return Locale.forLanguageTag(tag);
    }

    private static String stripExtension(String path) {
        int extensionIndex = path.lastIndexOf(".");
        if (extensionIndex != -1) {
            path = path.substring(0, extensionIndex);
        }
        return path;
    }

    private static class IteratorEnumeration<T>
    implements Enumeration<T> {
        private final Iterator<T> source;

        IteratorEnumeration(Iterator<T> source) {
            this.source = source;
        }

        @Override
        public boolean hasMoreElements() {
            return this.source.hasNext();
        }

        @Override
        public T nextElement() {
            return this.source.next();
        }
    }
}

