/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.demo.service;

import dev.onvoid.webrtc.RTCIceCandidate;
import dev.onvoid.webrtc.RTCPeerConnectionState;
import dev.onvoid.webrtc.RTCRtpTransceiverDirection;
import dev.onvoid.webrtc.RTCSdpType;
import dev.onvoid.webrtc.RTCSessionDescription;
import dev.onvoid.webrtc.RTCStatsReport;
import dev.onvoid.webrtc.demo.config.Configuration;
import dev.onvoid.webrtc.demo.model.Contact;
import dev.onvoid.webrtc.demo.model.Contacts;
import dev.onvoid.webrtc.demo.model.message.ChatMessage;
import dev.onvoid.webrtc.demo.net.PeerConnectionClient;
import dev.onvoid.webrtc.demo.net.PeerConnectionContext;
import dev.onvoid.webrtc.demo.net.SignalingClient;
import dev.onvoid.webrtc.media.video.VideoFrame;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PeerConnectionService {
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final Configuration config;
    private final SignalingClient signalingClient;
    private final PeerConnectionContext peerConnectionContext;
    private final Map<Contact, PeerConnectionClient> connections;
    private Contact activeContact;

    @Inject
    PeerConnectionService(Configuration config, SignalingClient client) {
        this.config = config;
        this.signalingClient = client;
        this.signalingClient.setSessionDescriptionConsumer(this::onSessionDescription);
        this.signalingClient.setIceCandidateConsumer(this::onIceCandidate);
        this.connections = new HashMap<Contact, PeerConnectionClient>();
        this.peerConnectionContext = new PeerConnectionContext();
        this.peerConnectionContext.audioDirection = RTCRtpTransceiverDirection.SEND_RECV;
        this.peerConnectionContext.videoDirection = RTCRtpTransceiverDirection.SEND_RECV;
    }

    public void dispose() {
        this.executor.shutdown();
    }

    public void setContactEventConsumer(BiConsumer<Contact, Boolean> consumer) {
        this.signalingClient.setContactEventConsumer(consumer);
    }

    public void setOnConnectionState(BiConsumer<Contact, RTCPeerConnectionState> consumer) {
        this.peerConnectionContext.onPeerConnectionState = consumer;
    }

    public void setOnRemoteFrame(BiConsumer<Contact, VideoFrame> consumer) {
        this.peerConnectionContext.onRemoteFrame = consumer;
    }

    public void setOnLocalFrame(Consumer<VideoFrame> consumer) {
        this.peerConnectionContext.onLocalFrame = consumer;
    }

    public void setOnStatsReport(Consumer<RTCStatsReport> consumer) {
        this.peerConnectionContext.onStatsReport = consumer;
    }

    public void setOnMessage(BiConsumer<Contact, ChatMessage> consumer) {
        this.peerConnectionContext.onMessage = consumer;
    }

    public void setOnRemoteVideoStream(BiConsumer<Contact, Boolean> consumer) {
        this.peerConnectionContext.onRemoteVideoStream = consumer;
    }

    public void setOnLocalVideoStream(Consumer<Boolean> consumer) {
        this.peerConnectionContext.onLocalVideoStream = consumer;
    }

    public boolean hasLocalVideoStream() {
        PeerConnectionClient peerConnectionClient = this.getPeerConnectionClient(this.activeContact);
        return Objects.nonNull(peerConnectionClient) && peerConnectionClient.hasLocalVideoStream();
    }

    public boolean hasRemoteVideoStream() {
        PeerConnectionClient peerConnectionClient = this.getPeerConnectionClient(this.activeContact);
        return Objects.nonNull(peerConnectionClient) && peerConnectionClient.hasRemoteVideoStream();
    }

    public CompletableFuture<Contacts> getContacts() {
        return CompletableFuture.supplyAsync(() -> {
            Contacts contacts = new Contacts();
            try {
                contacts.addAll(this.signalingClient.getRemotePeers());
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
            return contacts;
        });
    }

    public CompletableFuture<Void> login(Contact asContact) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.signalingClient.login(asContact);
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<Void> logout() {
        CompletableFuture<Void> closing = this.closeConnections();
        return CompletableFuture.allOf(closing, CompletableFuture.runAsync(() -> {
            try {
                this.signalingClient.logout();
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }));
    }

    public CompletableFuture<Void> sendMessage(ChatMessage message, Contact toContact) {
        PeerConnectionClient peerConnectionClient = this.getPeerConnectionClient(toContact);
        return peerConnectionClient.sendMessage(message);
    }

    public CompletableFuture<Void> connect(Contact contact) {
        return CompletableFuture.runAsync(() -> {
            try {
                PeerConnectionClient peerConnectionClient = this.getPeerConnectionClient(contact);
                if (Objects.isNull(peerConnectionClient)) {
                    peerConnectionClient = this.createPeerConnection(contact);
                    peerConnectionClient.establishDataLink();
                }
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }

    public void disconnect(Contact contact) {
        PeerConnectionClient peerConnectionClient = this.removePeerConnectionClient(contact);
        if (Objects.nonNull(peerConnectionClient)) {
            peerConnectionClient.close();
        }
    }

    public CompletableFuture<Void> call(Contact contact, boolean enableVideo) {
        this.peerConnectionContext.videoDirection = enableVideo ? RTCRtpTransceiverDirection.SEND_RECV : RTCRtpTransceiverDirection.INACTIVE;
        return CompletableFuture.runAsync(() -> {
            PeerConnectionClient peerConnectionClient = this.getPeerConnectionClient(contact);
            peerConnectionClient.initCall();
            this.activeContact = contact;
        });
    }

    public void setDesktopActive(boolean active) {
        PeerConnectionClient peerConnectionClient = this.getPeerConnectionClient(this.activeContact);
        if (Objects.nonNull(peerConnectionClient)) {
            peerConnectionClient.setDesktopActive(active);
        }
    }

    public void setMicrophoneActive(boolean active) {
        PeerConnectionClient peerConnectionClient = this.getPeerConnectionClient(this.activeContact);
        if (Objects.nonNull(peerConnectionClient)) {
            peerConnectionClient.setMicrophoneActive(active);
        }
    }

    public void setCameraActive(boolean active) {
        PeerConnectionClient peerConnectionClient = this.getPeerConnectionClient(this.activeContact);
        if (Objects.nonNull(peerConnectionClient)) {
            peerConnectionClient.setCameraActive(active);
        }
    }

    public void enableStats(boolean active) {
        PeerConnectionClient peerConnectionClient = this.getPeerConnectionClient(this.activeContact);
        if (Objects.nonNull(peerConnectionClient)) {
            peerConnectionClient.enableStatsEvents(active, 5000);
        }
    }

    public CompletableFuture<Void> hangup() {
        PeerConnectionClient peerConnectionClient = this.getPeerConnectionClient(this.activeContact);
        if (Objects.isNull(peerConnectionClient)) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> close = peerConnectionClient.close();
        close.thenRun(() -> {
            this.activeContact = null;
        });
        return CompletableFuture.allOf(close, this.logout());
    }

    private CompletableFuture<Void> closeConnections() {
        Collection<PeerConnectionClient> clients = this.connections.values();
        Iterator<PeerConnectionClient> iter = clients.iterator();
        CompletableFuture[] list = new CompletableFuture[clients.size()];
        int index = 0;
        while (iter.hasNext()) {
            PeerConnectionClient client = iter.next();
            iter.remove();
            list[index++] = client.close();
        }
        return CompletableFuture.allOf(list);
    }

    private PeerConnectionClient getPeerConnectionClient(Contact contact) {
        return this.connections.get(contact);
    }

    private PeerConnectionClient removePeerConnectionClient(Contact contact) {
        return this.connections.remove(contact);
    }

    private PeerConnectionClient createPeerConnection(Contact contact) {
        PeerConnectionClient peerConnectionClient = this.getPeerConnectionClient(contact);
        if (Objects.nonNull(peerConnectionClient)) {
            return peerConnectionClient;
        }
        peerConnectionClient = new PeerConnectionClient(this.config, contact, this.peerConnectionContext, this.signalingClient, this.executor);
        this.connections.put(contact, peerConnectionClient);
        return peerConnectionClient;
    }

    private void onSessionDescription(Contact contact, RTCSessionDescription description) {
        if (description.sdpType == RTCSdpType.OFFER) {
            this.createPeerConnection(contact);
        }
        PeerConnectionClient peerConnectionClient = this.getPeerConnectionClient(contact);
        peerConnectionClient.setSessionDescription(description);
    }

    private void onIceCandidate(Contact contact, RTCIceCandidate candidate) {
        PeerConnectionClient peerConnectionClient = this.getPeerConnectionClient(contact);
        peerConnectionClient.addIceCandidate(candidate);
    }
}

