/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.demo.presenter;

import dev.onvoid.webrtc.demo.config.Configuration;
import dev.onvoid.webrtc.demo.config.VideoConfiguration;
import dev.onvoid.webrtc.demo.presenter.Presenter;
import dev.onvoid.webrtc.demo.view.VideoSettingsView;
import dev.onvoid.webrtc.media.video.VideoCaptureCapability;
import dev.onvoid.webrtc.media.video.VideoDevice;
import dev.onvoid.webrtc.media.video.VideoDeviceModule;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;

public class VideoSettingsPresenter
extends Presenter<VideoSettingsView> {
    private final VideoConfiguration config;
    private final VideoDeviceModule videoModule;

    @Inject
    VideoSettingsPresenter(VideoSettingsView view, Configuration config) {
        super(view);
        this.config = config.getVideoConfiguration();
        this.videoModule = new VideoDeviceModule();
    }

    @Override
    public void initialize() {
        VideoDevice device;
        List devices = this.videoModule.getCaptureDevices();
        int devIndex = devices.indexOf(device = this.config.getCaptureDevice());
        device = devIndex < 0 ? (VideoDevice)devices.get(0) : (VideoDevice)devices.get(devIndex);
        List capabilities = this.videoModule.getCaptureCapabilities(device);
        capabilities.sort(new VideoCaptureCapabilityComparator());
        VideoCaptureCapability capability = this.getCaptureCapability(capabilities);
        this.config.setCaptureDevice(device);
        this.config.setCaptureCapability(capability);
        this.config.captureDeviceProperty().addListener((observable, oldDevice, newDevice) -> this.onVideoCaptureDevice((VideoDevice)newDevice));
        ((VideoSettingsView)this.view).setVideoDevices(devices);
        ((VideoSettingsView)this.view).setVideoDevice(this.config.captureDeviceProperty());
        ((VideoSettingsView)this.view).setVideoCaptureCapabilities(capabilities);
        ((VideoSettingsView)this.view).setVideoCaptureCapability(this.config.captureCapabilityProperty());
        ((VideoSettingsView)this.view).setReceiveVideo(this.config.receiveVideoProperty());
        ((VideoSettingsView)this.view).setSendVideo(this.config.sendVideoProperty());
    }

    private void onVideoCaptureDevice(VideoDevice device) {
        System.out.println("onVideoCaptureDevice: " + device);
        List capabilities = this.videoModule.getCaptureCapabilities(device);
        capabilities.sort(new VideoCaptureCapabilityComparator());
        VideoCaptureCapability capability = this.getCaptureCapability(capabilities);
        ((VideoSettingsView)this.view).setVideoCaptureCapabilities(capabilities);
        this.config.setCaptureCapability(capability);
        this.config.captureCapabilityProperty().notifyValueChanged();
    }

    private VideoCaptureCapability getCaptureCapability(List<VideoCaptureCapability> capabilities) {
        VideoCaptureCapability capability = this.config.getCaptureCapability();
        int capIndex = capabilities.indexOf(capability);
        if (capIndex < 0) {
            return capabilities.stream().filter(cap -> cap.width == 1280 && cap.height == 720).findAny().orElse(capabilities.get(0));
        }
        return capabilities.get(capIndex);
    }

    static class VideoCaptureCapabilityComparator
    implements Comparator<VideoCaptureCapability> {
        VideoCaptureCapabilityComparator() {
        }

        @Override
        public int compare(VideoCaptureCapability a, VideoCaptureCapability b) {
            if (a.width == b.width) {
                if (a.height == b.height) {
                    return a.frameRate - b.frameRate;
                }
                return a.height - b.height;
            }
            return a.width - b.width;
        }
    }
}

