/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.demo.presenter;

import dev.onvoid.webrtc.demo.context.ApplicationContext;
import dev.onvoid.webrtc.demo.event.LoggedInEvent;
import dev.onvoid.webrtc.demo.presenter.Presenter;
import dev.onvoid.webrtc.demo.service.PeerConnectionService;
import dev.onvoid.webrtc.demo.view.StartView;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;

public class StartPresenter
extends Presenter<StartView> {
    private final ApplicationContext context;
    private final PeerConnectionService peerConnectionService;

    @Inject
    StartPresenter(StartView view, ApplicationContext context, PeerConnectionService peerConnectionService) {
        super(view);
        this.context = context;
        this.peerConnectionService = peerConnectionService;
    }

    @Override
    public void initialize() {
        ((StartView)this.view).setUsername(this.context.getMyContact().getName());
        ((StartView)this.view).setOnConnect(this::onConnect);
    }

    private void onConnect() {
        this.context.getMyContact().setName(((StartView)this.view).getUsername());
        ((CompletableFuture)this.peerConnectionService.login(this.context.getMyContact()).thenRunAsync(this::onConnectSuccess)).exceptionally(this::onConnectError);
    }

    private void onConnectSuccess() {
        this.publishEvent(new LoggedInEvent(this.context.getMyContact()));
    }

    private Void onConnectError(Throwable error) {
        ((StartView)this.view).setError(error.getCause().getMessage());
        return null;
    }
}

