/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.demo.presenter;

import dev.onvoid.webrtc.demo.event.ApplicationEvent;
import dev.onvoid.webrtc.demo.view.Action;
import dev.onvoid.webrtc.demo.view.View;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public abstract class Presenter<T extends View> {
    private static System.Logger LOGGER = System.getLogger(Presenter.class.getName());
    protected final T view;
    private Presenter<?> parent;
    private Set<Presenter<?>> children;
    private Action closeAction;

    Presenter(T view) {
        Objects.requireNonNull(view);
        this.view = view;
        this.children = new HashSet();
    }

    public T getView() {
        return this.view;
    }

    public abstract void initialize();

    public void close() {
        if (Objects.nonNull(this.closeAction)) {
            this.closeAction.execute();
        }
    }

    public void destroy() {
        for (Presenter<?> child : this.children) {
            child.destroy();
        }
        this.children.clear();
    }

    public void setOnClose(Action action) {
        this.closeAction = action;
    }

    protected void addChild(Presenter<?> child) {
        this.children.add(child);
    }

    protected void removeChild(Presenter<?> child) {
        this.children.remove(child);
    }

    protected void setParent(Presenter<?> parent) {
        this.parent = parent;
    }

    protected void publishEvent(ApplicationEvent event) {
        if (Objects.nonNull(this.parent)) {
            this.parent.handleEvent(event);
        }
    }

    protected void handleEvent(ApplicationEvent event) {
        for (Presenter<?> child : this.children) {
            child.handleEvent(event);
        }
    }

    protected void handleException(Throwable throwable, String errorMessage, String title) {
        this.handleException(throwable, errorMessage, title, null);
    }

    protected final void handleException(Throwable throwable, String throwMessage, String title, String message) {
        this.logException(throwable, throwMessage);
        this.showError(title, message);
    }

    protected final void logException(Throwable throwable, String throwMessage) {
        Objects.requireNonNull(throwable);
        Objects.requireNonNull(throwMessage);
        LOGGER.log(System.Logger.Level.ERROR, throwMessage, throwable);
    }

    protected final void showError(String title, String message) {
        Objects.requireNonNull(title);
    }
}

